/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonArray_Type;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.TOP;

public final class LongArray_Type
extends CommonArray_Type {
    public static final int typeIndexID = LongArray.typeIndexID;
    private final FSGenerator fsGenerator = new FSGenerator(){

        @Override
        public FeatureStructure createFS(int addr, CASImpl cas) {
            if (LongArray_Type.this.useExistingInstance) {
                TOP fs = LongArray_Type.this.jcas.getJfsFromCaddr(addr);
                if (null == fs) {
                    fs = new LongArray(addr, LongArray_Type.this);
                    LongArray_Type.this.jcas.putJfsFromCaddr(addr, fs);
                    return fs;
                }
                return fs;
            }
            return new LongArray(addr, LongArray_Type.this);
        }
    };

    @Override
    protected FSGenerator getFSGenerator() {
        return this.fsGenerator;
    }

    private LongArray_Type() {
    }

    public LongArray_Type(JCas jcas, Type casType) {
        super(jcas, casType);
        this.casImpl.getFSClassRegistry().addGeneratorForType((TypeImpl)this.casType, this.getFSGenerator());
    }

    public long get(int addr, int i) {
        if (this.lowLevelTypeChecks) {
            return this.ll_cas.ll_getLongArrayValue(addr, i, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        return this.ll_cas.ll_getLongArrayValue(addr, i);
    }

    public void set(int addr, int i, long v) {
        if (this.lowLevelTypeChecks) {
            this.ll_cas.ll_setLongArrayValue(addr, i, v, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        this.ll_cas.ll_setLongArrayValue(addr, i, v);
    }

    public void copyFromArray(int addr, long[] src, int srcOffset, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, destOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            this.ll_cas.ll_setLongArrayValue(addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int addr, int srcOffset, long[] dest, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, srcOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.ll_cas.ll_getLongArrayValue(addr, i + srcOffset);
        }
    }

    public long[] toArray(int addr) {
        int size = this.size(addr);
        long[] outArray = new long[size];
        this.copyToArray(addr, 0, outArray, 0, size);
        return outArray;
    }
}

