/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import org.apache.uima.internal.util.BinaryTree;
import org.apache.uima.internal.util.rb_trees.RBTKeyValuePair;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;

class RBTNode<T> {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private int key;
    private boolean color;
    private RBTNode<T> parent;
    RBTNode<T> left;
    RBTNode<T> right;
    T element;
    private static final int indentInc = 2;

    private RBTNode(int key, boolean color, RBTNode<T> parent, RBTNode<T> left, RBTNode<T> right, T element) {
        this.key = key;
        this.color = color;
        this.parent = parent;
        this.left = left;
        this.right = right;
        this.element = element;
    }

    RBTNode(int key, T element) {
        this(key, false, null, null, null, element);
    }

    static final <T> RBTNode<T> find(RBTNode<T> x, int key) {
        while (x != null && x.key != key) {
            if (key < x.key) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return x;
    }

    final RBTNode<T> successor() {
        RBTNode<T> x = this;
        if (x.right != null) {
            x = x.right;
            while (x.left != null) {
                x = x.left;
            }
            return x;
        }
        RBTNode<T> y = x.parent;
        while (y != null && x == y.right) {
            x = y;
            y = x.parent;
        }
        return y;
    }

    static final <T> boolean insert(RedBlackTree<T> tree, RBTNode<T> x) {
        if (!RBTNode.treeInsert(tree, x)) {
            return false;
        }
        x.color = true;
        while (x != tree.root && x.parent.color) {
            RBTNode<T> y;
            if (x.parent == x.parent.parent.left) {
                y = x.parent.parent.right;
                if (RBTNode.colorOf(y)) {
                    x.parent.color = false;
                    RBTNode.setColor(y, false);
                    x.parent.parent.color = true;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    super.leftRotate(tree);
                }
                x.parent.color = false;
                x.parent.parent.color = true;
                super.rightRotate(tree);
                continue;
            }
            y = x.parent.parent.left;
            if (RBTNode.colorOf(y)) {
                x.parent.color = false;
                RBTNode.setColor(y, false);
                x.parent.parent.color = true;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                super.rightRotate(tree);
            }
            x.parent.color = false;
            x.parent.parent.color = true;
            super.leftRotate(tree);
        }
        tree.root.color = false;
        return true;
    }

    private static final <T> boolean treeInsert(RedBlackTree<T> tree, RBTNode<T> z) {
        RBTNode y = null;
        RBTNode x = tree.root;
        while (x != null) {
            y = x;
            if (z.key < x.key) {
                x = x.left;
                continue;
            }
            if (z.key > x.key) {
                x = x.right;
                continue;
            }
            x.element = z.element;
            return false;
        }
        z.parent = y;
        if (y == null) {
            tree.root = z;
        } else if (z.key < y.key) {
            y.left = z;
        } else {
            y.right = z;
        }
        return true;
    }

    private final void leftRotate(RedBlackTree<T> tree) {
        RBTNode<T> y = this.right;
        this.right = y.left;
        if (y.left != null) {
            y.left.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.left) {
            this.parent.left = y;
        } else {
            this.parent.right = y;
        }
        y.left = this;
        this.parent = y;
    }

    private final void rightRotate(RedBlackTree<T> tree) {
        RBTNode<T> y = this.left;
        this.left = y.right;
        if (y.right != null) {
            y.right.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.right) {
            this.parent.right = y;
        } else {
            this.parent.left = y;
        }
        y.right = this;
        this.parent = y;
    }

    static final <T> void delete(RedBlackTree<T> tree, RBTNode<T> z) {
        RBTNode<T> xParent = null;
        RBTNode<T> y = z.left == null || z.right == null ? z : z.successor();
        RBTNode<T> x = y.left != null ? y.left : y.right;
        if (x != null) {
            x.parent = y.parent;
        } else {
            xParent = y.parent;
        }
        if (y.parent == null) {
            tree.root = x;
        } else if (y == y.parent.left) {
            y.parent.left = x;
        } else {
            y.parent.right = x;
        }
        if (y != z) {
            z.key = y.key;
            z.element = y.element;
        }
        if (!y.color) {
            if (x == null) {
                RBTNode.deleteFixupNull(tree, xParent);
            } else {
                RBTNode.deleteFixup(tree, x);
            }
        }
    }

    private static final <T> void deleteFixup(RedBlackTree<T> tree, RBTNode<T> x) {
        while (x != tree.root && !x.color) {
            RBTNode<T> w;
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w.color) {
                    w.color = false;
                    x.parent.color = true;
                    super.leftRotate(tree);
                    w = x.parent.right;
                }
                if (!RBTNode.colorOf(RBTNode.leftOf(w)) && !RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    x = x.parent;
                    continue;
                }
                if (!RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    super.rightRotate(tree);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                super.leftRotate(tree);
                x = tree.root;
                continue;
            }
            w = x.parent.left;
            if (w.color) {
                w.color = false;
                x.parent.color = true;
                super.rightRotate(tree);
                w = x.parent.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(w)) && !RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                x = x.parent;
                continue;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                super.leftRotate(tree);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            super.rightRotate(tree);
            x = tree.root;
        }
        x.color = false;
    }

    private static final <T> void deleteFixupNull(RedBlackTree<T> tree, RBTNode<T> x) {
        RBTNode<T> w;
        if (x == null) {
            return;
        }
        if (x.left == null) {
            w = x.right;
            if (w.color) {
                w.color = false;
                x.color = true;
                super.leftRotate(tree);
                w = x.right;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(w)) && !RBTNode.colorOf(RBTNode.rightOf(w))) {
                w.color = true;
            } else {
                if (!RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    super.rightRotate(tree);
                    w = x.right;
                }
                w.color = x.color;
                x.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                super.leftRotate(tree);
                x = tree.root;
            }
        } else {
            w = x.left;
            if (w.color) {
                w.color = false;
                x.color = true;
                super.rightRotate(tree);
                w = x.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(w)) && !RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
            } else {
                if (!RBTNode.colorOf(RBTNode.leftOf(w))) {
                    w.color = true;
                    super.leftRotate(tree);
                    w = x.left;
                }
                w.color = x.color;
                x.color = false;
                if (w.left != null) {
                    w.left.color = false;
                }
                super.rightRotate(tree);
                x = tree.root;
            }
        }
        while (x != tree.root && !x.color) {
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w.color) {
                    w.color = false;
                    x.parent.color = true;
                    super.leftRotate(tree);
                    w = x.parent.right;
                }
                if (!RBTNode.colorOf(RBTNode.leftOf(w)) && !RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    x = x.parent;
                    continue;
                }
                if (!RBTNode.colorOf(RBTNode.rightOf(w))) {
                    w.color = true;
                    super.rightRotate(tree);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                super.leftRotate(tree);
                x = tree.root;
                continue;
            }
            w = x.parent.left;
            if (w.color) {
                w.color = false;
                x.parent.color = true;
                super.rightRotate(tree);
                w = x.parent.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(w)) && !RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                x = x.parent;
                continue;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(w))) {
                w.color = true;
                super.leftRotate(tree);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            super.rightRotate(tree);
            x = tree.root;
        }
        x.color = false;
    }

    int keys(int pos, int[] keys) {
        int cur = pos;
        if (this.left != null) {
            cur = this.left.keys(cur, keys);
        }
        keys[cur] = this.key;
        ++cur;
        if (this.right != null) {
            cur = this.right.keys(cur, keys);
        }
        return cur;
    }

    private static final <T> boolean colorOf(RBTNode<T> x) {
        return x == null ? false : x.color;
    }

    private static final <T> void setColor(RBTNode<T> x, boolean c) {
        if (x != null) {
            x.color = c;
        }
    }

    private static final <T> RBTNode<T> leftOf(RBTNode<T> x) {
        return x == null ? null : x.left;
    }

    private static final <T> RBTNode<T> rightOf(RBTNode<T> x) {
        return x == null ? null : x.right;
    }

    public void printKeys(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.print(this.key);
        System.out.print(":");
        if (this.color) {
            System.out.println("red");
        } else {
            System.out.println("black");
        }
        indent += 2;
        if (this.left != null) {
            this.left.printKeys(indent);
        }
        if (this.right != null) {
            this.right.printKeys(indent);
        }
    }

    public void printElements(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println(this.element.toString());
        indent += 2;
        if (this.left != null) {
            this.left.printElements(indent);
        }
        if (this.right != null) {
            this.right.printElements(indent);
        }
    }

    void getBinaryTree(BinaryTree tree) {
        tree.setValue(new RBTKeyValuePair(this.key, this.element));
        if (this.left != null) {
            BinaryTree newLeft = tree.newLeftDtr();
            this.left.getBinaryTree(newLeft);
        }
        if (this.right != null) {
            BinaryTree newRight = tree.newRightDtr();
            this.right.getBinaryTree(newRight);
        }
    }
}

