/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.uima.internal.util.ComparableIntIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.rb_trees.IntArrayRBTcommon;

public class IntArrayRBT
extends IntArrayRBTcommon {
    protected final Random rand = new Random();

    public IntArrayRBT() {
        this(1024);
    }

    public IntArrayRBT(int initialSize) {
    }

    public int getKeyForNode(int node) {
        return this.getKey(node);
    }

    protected int treeInsert(int k) {
        if (this.greatestNode != 0 && this.getKey(this.greatestNode) < k) {
            int z;
            int y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
            this.setRight(y, z);
            this.setParent(z, y);
            return z;
        }
        int x = this.root;
        int y = 0;
        while (x != 0) {
            y = x;
            int xKey = this.getKey(x);
            if (k == xKey) {
                return -x;
            }
            x = k < xKey ? this.getLeft(x) : this.getRight(x);
        }
        int z = this.newNode(k);
        if (y == 0) {
            this.setAsRoot(z);
            this.greatestNode = z;
            this.setParent(z, 0);
        } else {
            this.setParent(z, y);
            if (k < this.getKey(y)) {
                this.setLeft(y, z);
            } else {
                this.setRight(y, z);
            }
        }
        return z;
    }

    protected int treeInsertWithDups(int k) {
        if (this.greatestNode != 0 && this.getKey(this.greatestNode) <= k) {
            int z;
            int y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
            this.setRight(y, z);
            this.setParent(z, y);
            return z;
        }
        int y = 0;
        int x = this.root;
        while (x != 0) {
            y = x;
            int xKey = this.getKey(x);
            x = k < xKey ? this.getLeft(x) : (k > xKey ? this.getRight(x) : (this.rand.nextBoolean() ? this.getLeft(x) : this.getRight(x)));
        }
        int z = this.newNode(k);
        if (y == 0) {
            this.setAsRoot(z);
            this.greatestNode = z;
            this.setParent(z, 0);
        } else {
            this.setParent(z, y);
            if (k < this.getKey(y)) {
                this.setLeft(y, z);
            } else if (k > this.getKey(y)) {
                this.setRight(y, z);
            } else if (this.rand.nextBoolean()) {
                this.setLeft(y, z);
            } else {
                this.setRight(y, z);
            }
        }
        return z;
    }

    public int insertKey(int k) {
        return this.insertKey(k, false);
    }

    public int add(int k) {
        return this.insertKey(k, false);
    }

    public boolean addAdded(int k) {
        if (this.root == 0) {
            int x = this.newNode(k);
            this.setAsRoot(x);
            this.color[this.root] = false;
            this.greatestNode = x;
            return true;
        }
        int x = this.treeInsert(k);
        if (x < 0) {
            return false;
        }
        this.commonInsertKey(x);
        return true;
    }

    public int insertKeyWithDups(int k) {
        return this.insertKey(k, true);
    }

    private int insertKey(int k, boolean withDups) {
        int x;
        if (this.root == 0) {
            int x2 = this.newNode(k);
            this.setAsRoot(x2);
            this.color[this.root] = false;
            this.greatestNode = x2;
            return x2;
        }
        int n = x = withDups ? this.treeInsertWithDups(k) : this.treeInsert(k);
        if (x < 0) {
            return -x;
        }
        return this.commonInsertKey(x);
    }

    private int commonInsertKey(int x) {
        this.color[x] = true;
        int node = x;
        while (x != this.root && this.color[this.getParent(x)]) {
            int parent2_parent2_x;
            int parent2_x;
            int y;
            int parent_parent_x;
            int parent_x = this.getParent(x);
            if (parent_x == this.getLeft(parent_parent_x = this.getParent(parent_x))) {
                y = this.getRight(parent_parent_x);
                if (this.color[y]) {
                    this.color[parent_x] = false;
                    this.color[y] = false;
                    this.color[parent_parent_x] = true;
                    x = parent_parent_x;
                    continue;
                }
                if (x == this.getRight(parent_x)) {
                    x = parent_x;
                    this.leftRotate(x);
                }
                parent2_x = this.getParent(x);
                this.color[parent2_x] = false;
                parent2_parent2_x = this.getParent(parent2_x);
                this.color[parent2_parent2_x] = true;
                this.rightRotate(parent2_parent2_x);
                continue;
            }
            y = this.getLeft(parent_parent_x);
            if (this.color[y]) {
                this.color[parent_x] = false;
                this.color[y] = false;
                this.color[parent_parent_x] = true;
                x = parent_parent_x;
                continue;
            }
            if (x == this.getLeft(parent_x)) {
                x = parent_x;
                this.rightRotate(x);
            }
            parent2_x = this.getParent(x);
            this.color[parent2_x] = false;
            parent2_parent2_x = this.getParent(parent2_x);
            this.color[parent2_parent2_x] = true;
            this.leftRotate(parent2_parent2_x);
        }
        this.color[this.root] = false;
        return node;
    }

    @Override
    public int findKey(int k) {
        int node = this.root;
        while (node != 0) {
            int keyNode = this.getKey(node);
            if (k < keyNode) {
                node = this.getLeft(node);
                continue;
            }
            if (k == keyNode) {
                return node;
            }
            node = this.getRight(node);
        }
        return 0;
    }

    public int findInsertionPoint(int k) {
        int node;
        int found = node = this.root;
        while (node != 0) {
            found = node;
            int keyNode = this.getKey(node);
            if (k < keyNode) {
                node = this.getLeft(node);
                continue;
            }
            if (k == keyNode) {
                int left_node;
                while ((left_node = this.getLeft(node)) != 0 && this.getKey(left_node) == keyNode) {
                    node = left_node;
                }
                return node;
            }
            node = this.getRight(node);
        }
        return found;
    }

    public boolean deleteKey(int aKey) {
        int node = this.findKey(aKey);
        if (node == 0) {
            return false;
        }
        this.deleteNode(node);
        --this.size;
        if (this.size == 0 && this.next > 0x200000) {
            this.flush();
        }
        return true;
    }

    public ComparableIntIterator iterator(IntComparator comp) {
        return new ComparableIterator(comp);
    }

    public IntListIterator iterator() {
        return new IntArrayRBTKeyIterator();
    }

    public IntPointerIterator pointerIterator() {
        return new PointerIterator();
    }

    public IntPointerIterator pointerIterator(int aKey) {
        PointerIterator it = new PointerIterator();
        it.currentNode = this.findKey(aKey);
        return it;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        ComparablePointerIterator cpi = new ComparablePointerIterator(comp);
        cpi.modificationSnapshot = detectIllegalIndexUpdates[typeCode];
        ComparablePointerIterator.access$402(cpi, detectIllegalIndexUpdates);
        cpi.typeCode = typeCode;
        return cpi;
    }

    private class ComparableIterator
    extends IntArrayRBTKeyIterator
    implements ComparableIntIterator {
        private final IntComparator comparator;

        private ComparableIterator(IntComparator comp) {
            this.comparator = comp;
        }

        public int compareTo(Object o) {
            ComparableIterator it = (ComparableIterator)o;
            return this.comparator.compare(IntArrayRBT.this.getKey(this.currentNode), it.getKey(it.currentNode));
        }
    }

    private class IntArrayRBTKeyIterator
    implements IntListIterator {
        protected int currentNode = 0;

        protected IntArrayRBTKeyIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.currentNode != IntArrayRBT.this.greatestNode;
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentNode = this.currentNode == 0 ? IntArrayRBT.this.getFirstNode() : IntArrayRBT.this.nextNode(this.currentNode);
            return IntArrayRBT.this.getKey(this.currentNode);
        }

        @Override
        public boolean hasPrevious() {
            return this.currentNode != 0;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            int currentKey = IntArrayRBT.this.getKey(this.currentNode);
            this.currentNode = this.currentNode == IntArrayRBT.this.getFirstNode() ? 0 : IntArrayRBT.this.previousNode(this.currentNode);
            return currentKey;
        }

        @Override
        public void moveToEnd() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        @Override
        public void moveToStart() {
            this.currentNode = 0;
        }

        protected final int getKey(int node) {
            return IntArrayRBT.this.getKey(node);
        }
    }

    private class PointerIterator
    implements IntPointerIterator {
        protected int currentNode;

        private PointerIterator() {
            this.moveToFirst();
        }

        @Override
        public void dec() {
            this.currentNode = IntArrayRBT.this.previousNode(this.currentNode);
        }

        @Override
        public int get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return IntArrayRBT.this.getKey(this.currentNode);
        }

        @Override
        public void inc() {
            this.currentNode = IntArrayRBT.this.nextNode(this.currentNode);
        }

        @Override
        public boolean isValid() {
            return this.currentNode != 0;
        }

        @Override
        public void moveToFirst() {
            this.currentNode = IntArrayRBT.this.getFirstNode();
        }

        @Override
        public void moveToLast() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        @Override
        public Object copy() {
            PointerIterator it = new PointerIterator();
            it.currentNode = this.currentNode;
            return it;
        }

        @Override
        public void moveTo(int i) {
            this.currentNode = IntArrayRBT.this.findInsertionPoint(i);
        }
    }

    private class ComparablePointerIterator
    extends PointerIterator
    implements ComparableIntPointerIterator {
        private final IntComparator comp;
        private int modificationSnapshot;
        private int[] detectIllegalIndexUpdates;
        private int typeCode;

        @Override
        public boolean isConcurrentModification() {
            return this.modificationSnapshot != this.detectIllegalIndexUpdates[this.typeCode];
        }

        @Override
        public void resetConcurrentModification() {
            this.modificationSnapshot = this.detectIllegalIndexUpdates[this.typeCode];
        }

        private ComparablePointerIterator(IntComparator comp) {
            this.comp = comp;
        }

        public int compareTo(Object o) throws NoSuchElementException {
            ComparableIntPointerIterator it = (ComparableIntPointerIterator)o;
            return this.comp.compare(this.get(), it.get());
        }

        @Override
        public Object copy() {
            ComparablePointerIterator copy = new ComparablePointerIterator(this.comp);
            copy.currentNode = this.currentNode;
            return copy;
        }

        public String toString() {
            return "ComparablePointerIterator [comp=" + this.comp + ", typeCode=" + this.typeCode + ", currentNode=" + this.currentNode + "]";
        }

        static /* synthetic */ int[] access$402(ComparablePointerIterator x0, int[] x1) {
            x0.detectIllegalIndexUpdates = x1;
            return x1;
        }
    }
}

