/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.rb_trees.IntArrayRBT;

public class CompIntArrayRBT
extends IntArrayRBT {
    private IntComparator comp;

    public CompIntArrayRBT(IntComparator comp) {
        this(comp, 1024);
    }

    public CompIntArrayRBT(IntComparator comp, int initialSize) {
        super(initialSize);
        this.comp = comp;
    }

    @Override
    protected int treeInsert(int k) {
        int cv;
        int z;
        int x = this.root;
        int y = 0;
        if (this.greatestNode != 0 && this.comp.compare(this.getKey(this.greatestNode), k) < 0) {
            y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
        } else {
            while (x != 0) {
                y = x;
                cv = this.comp.compare(k, this.getKey(x));
                if (cv < 0) {
                    x = this.getLeft(x);
                    continue;
                }
                if (cv > 0) {
                    x = this.getRight(x);
                    continue;
                }
                return x;
            }
            z = this.newNode(k);
        }
        if (y == 0) {
            this.root = z;
            this.greatestNode = z;
            this.setParent(z, 0);
        } else {
            this.setParent(z, y);
            cv = this.comp.compare(k, this.getKey(y));
            if (cv < 0) {
                this.setLeft(y, z);
            } else {
                this.setRight(y, z);
            }
        }
        return z;
    }

    @Override
    protected int treeInsertWithDups(int k) {
        int cv;
        int x = this.root;
        boolean wentLeft = false;
        if (this.greatestNode != 0 && this.comp.compare(this.getKey(this.greatestNode), k) <= 0) {
            int z;
            int y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
            this.setParent(z, y);
            this.setRight(y, z);
            return z;
        }
        int y = 0;
        while (x != 0) {
            y = x;
            int xKey = this.getKey(x);
            cv = this.comp.compare(k, xKey);
            if (cv < 0) {
                x = this.getLeft(x);
                continue;
            }
            if (cv > 0) {
                x = this.getRight(x);
                continue;
            }
            if (this.rand.nextBoolean()) {
                wentLeft = true;
                x = this.getLeft(x);
                continue;
            }
            wentLeft = false;
            x = this.getRight(x);
        }
        int z = this.newNode(k);
        if (y == 0) {
            this.root = z;
            this.greatestNode = z;
            this.setParent(z, 0);
        } else {
            this.setParent(z, y);
            cv = this.comp.compare(k, this.getKey(y));
            if (cv < 0) {
                this.setLeft(y, z);
            } else if (cv > 0) {
                this.setRight(y, z);
            } else if (wentLeft) {
                this.setLeft(y, z);
            } else {
                this.setRight(y, z);
            }
        }
        return z;
    }

    @Override
    public int findKey(int k) {
        int node = this.root;
        while (node != 0) {
            int cv = this.comp.compare(k, this.getKey(node));
            if (cv < 0) {
                node = this.getLeft(node);
                continue;
            }
            if (cv > 0) {
                node = this.getRight(node);
                continue;
            }
            return node;
        }
        return 0;
    }

    @Override
    public int findInsertionPoint(int k) {
        int node = this.root;
        int found = this.root;
        int cv = 0;
        while (node != 0) {
            found = node;
            cv = this.comp.compare(k, this.getKey(node));
            if (cv < 0) {
                node = this.getLeft(node);
                continue;
            }
            if (cv > 0) {
                node = this.getRight(node);
                continue;
            }
            return node;
        }
        if (cv > 0) {
            return this.nextNode(found);
        }
        return found;
    }
}

