/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class UIMALogFormatter
extends Formatter {
    SimpleDateFormat tsFormatter = new SimpleDateFormat("hh:mm:ss.SS");
    private static final String CRLF = System.getProperties().getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord record) {
        if (record == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(100);
        Date timestamp = new Date(record.getMillis());
        String timestampStr = this.tsFormatter.format(timestamp);
        buffer.append(timestampStr);
        buffer.append(" - ");
        buffer.append(record.getThreadID());
        buffer.append(": ");
        if (record.getSourceClassName() == null || record.getSourceClassName().equals("")) {
            buffer.append(record.getLoggerName());
        } else {
            buffer.append(record.getSourceClassName());
        }
        if (record.getSourceMethodName() != null) {
            buffer.append(".");
            buffer.append(record.getSourceMethodName());
        }
        buffer.append(": ");
        buffer.append(record.getLevel().getLocalizedName());
        buffer.append(": ");
        buffer.append(record.getMessage());
        if (record.getThrown() != null) {
            buffer.append(CRLF);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            record.getThrown().printStackTrace(printWriter);
            printWriter.close();
            buffer.append(stringWriter.toString());
        }
        buffer.append(CRLF);
        return buffer.toString();
    }
}

