/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jsbd.postprocessingfilters;

import de.julielab.jcore.ae.jsbd.AbbreviationsBiomed;
import de.julielab.jcore.ae.jsbd.AbbreviationsMedical;
import de.julielab.jcore.ae.jsbd.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Stream;

public class PostprocessingFilter {
    public static final String BIOMED_POSTPROC = "biomed";
    public static final String MEDICAL_POSTPROC = "medical";
    public static final Stream<String> POSTPROC_STREAM = Stream.of("biomed", "medical");

    public static List<String> medicalPostprocessingFilter(List<String> predLabels, List<Unit> units) {
        String unitRep;
        int i;
        AbbreviationsMedical abr = new AbbreviationsMedical();
        TreeSet<String> abrSet = abr.getSet();
        String[] labels = predLabels.toArray(new String[predLabels.size()]);
        ArrayList<String> newPred = new ArrayList<String>();
        int openNormalBrackets = 0;
        int openSquareBrackets = 0;
        int count = 0;
        for (i = 0; i < labels.length; ++i) {
            unitRep = units.get((int)i).rep;
            char[] c = unitRep.toCharArray();
            block7: for (int j = 0; j < c.length; ++j) {
                switch (c[j]) {
                    case '(': {
                        ++openNormalBrackets;
                        continue block7;
                    }
                    case '[': {
                        ++openSquareBrackets;
                        continue block7;
                    }
                    case ')': {
                        --openNormalBrackets;
                        continue block7;
                    }
                    case ']': {
                        --openSquareBrackets;
                    }
                }
            }
            if (openSquareBrackets > 0 || openNormalBrackets > 0) {
                labels[i] = "IS";
                ++count;
            }
            if (count >= 50) {
                openSquareBrackets = 0;
                openNormalBrackets = 0;
            }
            if (openSquareBrackets < 0) {
                openSquareBrackets = 0;
            }
            if (openNormalBrackets >= 0) continue;
            openNormalBrackets = 0;
        }
        for (i = 0; i < labels.length; ++i) {
            unitRep = units.get((int)i).rep;
            if (abrSet.contains(unitRep)) {
                labels[i] = "IS";
            }
            if (unitRep.endsWith(".\"") || unitRep.endsWith("?") || unitRep.endsWith("!")) {
                labels[i] = "EOS";
            }
            newPred.add(labels[i]);
        }
        return newPred;
    }

    public static List<String> biomedPostprocessingFilter(List<String> predLabels, List<Unit> units) {
        String unitRep;
        int i;
        AbbreviationsBiomed abr = new AbbreviationsBiomed();
        TreeSet<String> abrSet = abr.getSet();
        String[] labels = predLabels.toArray(new String[predLabels.size()]);
        ArrayList<String> newPred = new ArrayList<String>();
        int openNormalBrackets = 0;
        int openSquareBrackets = 0;
        int count = 0;
        for (i = 0; i < labels.length; ++i) {
            unitRep = units.get((int)i).rep;
            char[] c = unitRep.toCharArray();
            block7: for (int j = 0; j < c.length; ++j) {
                switch (c[j]) {
                    case '(': {
                        ++openNormalBrackets;
                        continue block7;
                    }
                    case '[': {
                        ++openSquareBrackets;
                        continue block7;
                    }
                    case ')': {
                        --openNormalBrackets;
                        continue block7;
                    }
                    case ']': {
                        --openSquareBrackets;
                    }
                }
            }
            if (openSquareBrackets > 0 || openNormalBrackets > 0) {
                labels[i] = "IS";
                ++count;
            }
            if (count >= 50) {
                openSquareBrackets = 0;
                openNormalBrackets = 0;
            }
            if (openSquareBrackets < 0) {
                openSquareBrackets = 0;
            }
            if (openNormalBrackets >= 0) continue;
            openNormalBrackets = 0;
        }
        for (i = 0; i < labels.length; ++i) {
            unitRep = units.get((int)i).rep;
            if (abrSet.contains(unitRep)) {
                labels[i] = "IS";
            }
            if (unitRep.endsWith(".\"") || unitRep.endsWith("?") || unitRep.endsWith("!")) {
                labels[i] = "EOS";
            }
            newPred.add(labels[i]);
        }
        return newPred;
    }

    public static enum Mode {
        BIOMED{

            @Override
            public List<String> process(List<String> predLabels, List<Unit> units) {
                return PostprocessingFilter.biomedPostprocessingFilter(predLabels, units);
            }
        }
        ,
        MEDICAL{

            @Override
            public List<String> process(List<String> predLabels, List<Unit> units) {
                return PostprocessingFilter.medicalPostprocessingFilter(predLabels, units);
            }
        };


        public abstract List<String> process(List<String> var1, List<Unit> var2);
    }
}

