/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.component.NoOpAnnotator;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.fit.util.LifeCycleUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

public class JCasIterator
implements Iterator<JCas> {
    private final CollectionReader collectionReader;
    private final AnalysisEngine[] analysisEngines;
    private final JCas jCas;
    private final ResourceManager resMgr;
    private boolean selfComplete = false;
    private boolean selfDestroy = false;
    private boolean destroyed = false;
    private boolean resourceManagerCreatedInternally = false;

    public JCasIterator(CollectionReaderDescription aReader, AnalysisEngineDescription ... aEngines) throws CASException, ResourceInitializationException {
        this(null, aReader, aEngines);
    }

    public JCasIterator(ResourceManager aResMgr, CollectionReaderDescription aReader, AnalysisEngineDescription ... aEngines) throws CASException, ResourceInitializationException {
        this.selfComplete = true;
        this.selfDestroy = true;
        if (aResMgr == null) {
            this.resMgr = ResourceManagerFactory.newResourceManager();
            this.resourceManagerCreatedInternally = true;
        } else {
            this.resMgr = aResMgr;
            this.resourceManagerCreatedInternally = false;
        }
        this.collectionReader = UIMAFramework.produceCollectionReader(aReader, this.resMgr, null);
        this.analysisEngines = new AnalysisEngine[]{UIMAFramework.produceAnalysisEngine((ResourceSpecifier)AnalysisEngineFactory.createEngineDescription(aEngines), this.resMgr, null)};
        this.jCas = this.createCas(this.resMgr, this.collectionReader, this.analysisEngines);
        this.collectionReader.typeSystemInit(this.jCas.getTypeSystem());
    }

    public JCasIterator(CollectionReader aReader, AnalysisEngine ... aEngines) throws CASException, ResourceInitializationException {
        this(ResourceManagerFactory.newResourceManager(), aReader, aEngines);
        this.resourceManagerCreatedInternally = true;
    }

    public JCasIterator(CollectionReader aReader, TypeSystemDescription aTypeSystemDescription) throws CASException, ResourceInitializationException {
        this(aReader, AnalysisEngineFactory.createEngine(NoOpAnnotator.class, aTypeSystemDescription, new Object[0]));
    }

    public JCasIterator(ResourceManager aResMgr, CollectionReader aReader, AnalysisEngine ... aEngines) throws CASException, ResourceInitializationException {
        if (aResMgr == null) {
            this.resMgr = ResourceManagerFactory.newResourceManager();
            this.resourceManagerCreatedInternally = true;
        } else {
            this.resMgr = aResMgr;
            this.resourceManagerCreatedInternally = false;
        }
        this.collectionReader = aReader;
        this.analysisEngines = aEngines;
        this.jCas = this.createCas(this.resMgr, this.collectionReader, this.analysisEngines);
        this.collectionReader.typeSystemInit(this.jCas.getTypeSystem());
    }

    private JCas createCas(ResourceManager aResMgr, CollectionReader aReader, AnalysisEngine ... aEngines) throws CASException, ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> metaData = new ArrayList<ProcessingResourceMetaData>();
        metaData.add(aReader.getProcessingResourceMetaData());
        for (AnalysisEngine ae : aEngines) {
            metaData.add(ae.getProcessingResourceMetaData());
        }
        return CasCreationUtils.createCas(metaData, null, aResMgr).getJCas();
    }

    @Override
    public boolean hasNext() {
        if (this.destroyed) {
            return false;
        }
        boolean error = true;
        try {
            boolean hasOneMore = this.collectionReader.hasNext();
            error = false;
            boolean bl = hasOneMore;
            return bl;
        }
        catch (CollectionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (error && this.selfDestroy) {
                this.destroy();
            }
        }
    }

    @Override
    public JCas next() {
        this.jCas.reset();
        boolean error = true;
        boolean destroyed = false;
        try {
            this.collectionReader.getNext(this.jCas.getCas());
            for (AnalysisEngine engine : this.analysisEngines) {
                engine.process(this.jCas);
            }
            if ((this.selfComplete || this.selfDestroy) && !this.hasNext()) {
                if (this.selfComplete) {
                    this.collectionProcessComplete();
                }
                if (this.selfDestroy) {
                    this.destroy();
                    destroyed = true;
                }
            }
            error = false;
        }
        catch (CollectionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (AnalysisEngineProcessException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (error && this.selfDestroy && !destroyed) {
                this.destroy();
            }
        }
        return this.jCas;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        LifeCycleUtil.collectionProcessComplete(this.analysisEngines);
    }

    public void destroy() {
        if (!this.destroyed) {
            LifeCycleUtil.close(this.collectionReader);
            LifeCycleUtil.destroy(this.collectionReader);
            LifeCycleUtil.destroy(this.analysisEngines);
            if (this.resourceManagerCreatedInternally) {
                LifeCycleUtil.destroy(this.resMgr);
            }
            this.destroyed = true;
        }
    }

    public boolean isSelfComplete() {
        return this.selfComplete;
    }

    public void setSelfComplete(boolean aSelfComplete) {
        this.selfComplete = aSelfComplete;
    }

    public boolean isSelfDestroy() {
        return this.selfDestroy;
    }

    public void setSelfDestroy(boolean aSelfDestroy) {
        this.selfDestroy = aSelfDestroy;
    }
}

