/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.SynsetProxy;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.princeton.data.AbstractPrincetonDatabaseDictionaryElementFactory;
import net.didion.jwnl.princeton.data.MutableVerb;

public class PrincetonWN30DatabaseDictionaryElementFactory
extends AbstractPrincetonDatabaseDictionaryElementFactory {
    @Override
    public Object create(Map params) throws JWNLException {
        return new PrincetonWN30DatabaseDictionaryElementFactory();
    }

    @Override
    public Synset createSynset(POS pos, long offset, ResultSet synset, ResultSet words, ResultSet pointers, ResultSet verbFrames) throws SQLException {
        synset.next();
        boolean isAdjectiveCluster = synset.getBoolean(1);
        String gloss = synset.getString(2);
        SynsetProxy proxy = new SynsetProxy(pos);
        ArrayList<Word> wordList = new ArrayList<Word>();
        while (words.next()) {
            String lemma = words.getString(1);
            int index = words.getInt(2);
            String senseKey = words.getString(3);
            int usageCnt = words.getInt(4);
            wordList.add(this.createWord(proxy, index, lemma, senseKey, usageCnt));
        }
        ArrayList<Pointer> pointerList = new ArrayList<Pointer>();
        while (pointers.next()) {
            PointerType type = PointerType.getPointerTypeForKey(pointers.getString(1));
            long targetOffset = pointers.getLong(2);
            POS targetPOS = POS.getPOSForKey(pointers.getString(3));
            int sourceIndex = pointers.getInt(4);
            int targetIndex = pointers.getInt(5);
            pointerList.add(new Pointer(proxy, sourceIndex, type, targetPOS, targetOffset, targetIndex));
        }
        while (verbFrames.next()) {
            int frameNumber = verbFrames.getInt(1);
            int wordIndex = verbFrames.getInt(2);
            if (wordIndex > 0) {
                ((MutableVerb)wordList.get(wordIndex - 1)).setVerbFrameFlag(frameNumber);
                continue;
            }
            Iterator itr = wordList.iterator();
            while (itr.hasNext()) {
                ((MutableVerb)itr.next()).setVerbFrameFlag(frameNumber);
            }
        }
        BitSet verbFrameBits = new BitSet();
        for (Word word : wordList) {
            if (!(word instanceof Verb)) continue;
            verbFrameBits.or(((Verb)word).getVerbFrameFlags());
        }
        proxy.setSource(new Synset(pos, offset, wordList.toArray(new Word[wordList.size()]), pointerList.toArray(new Pointer[pointerList.size()]), gloss, verbFrameBits, isAdjectiveCluster));
        return proxy;
    }

    protected Word createWord(Synset synset, int index, String lemma, String senseKey, int usageCnt) {
        Word w = null;
        w = synset.getPOS().equals(POS.VERB) ? new MutableVerb(synset, index, lemma) : new Word(synset, index, lemma);
        return w;
    }
}

