/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.list;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.list.Node;
import net.didion.jwnl.data.list.NodePrinter;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetTreeNode;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;
import net.didion.jwnl.util.TypeCheckingList;

public class PointerTargetNodeList
extends TypeCheckingList {
    private static final NodePrinter PRINTER = new NodePrinter(System.out, 2){

        @Override
        public void print(PrintStream stream, Node node, int indent, int indentIncrement) {
            PointerTargetNode n = (PointerTargetNode)node;
            char[] c = new char[indent >= 0 ? indent : 0];
            Arrays.fill(c, ' ');
            stream.println(new String(c) + n);
        }
    };

    public PointerTargetNodeList() {
        this(new LinkedList());
    }

    public PointerTargetNodeList(LinkedList list) {
        this(list, PointerTargetNode.class);
    }

    public PointerTargetNodeList(PointerTarget[] targets) {
        this();
        for (int i = 0; i < targets.length; ++i) {
            this.add(targets[i]);
        }
    }

    protected PointerTargetNodeList(LinkedList list, Class type) {
        super(list, type, PointerTargetNode.class);
    }

    public void add(PointerTarget target) {
        this.add(new PointerTargetNode(target));
    }

    public void add(PointerTarget target, PointerType type) {
        this.add(new PointerTargetNode(target, type));
    }

    protected NodePrinter getNodePrinter() {
        return PRINTER;
    }

    public void print() {
        this.getNodePrinter().print(this.getTypeCheckingListIterator());
    }

    public void print(int indent) {
        this.getNodePrinter().print(this.getTypeCheckingListIterator(), indent);
    }

    public void print(PrintStream stream) {
        this.getNodePrinter().print(this.getTypeCheckingListIterator(), stream);
    }

    public void print(PrintStream stream, int indent) {
        this.getNodePrinter().print(this.getTypeCheckingListIterator(), stream, indent);
    }

    protected void print(PrintStream stream, int indent, int indentIncrement) {
        this.getNodePrinter().print(this.getTypeCheckingListIterator(), stream, indent, indentIncrement);
    }

    public PointerTargetTreeNodeList toTreeList() {
        TypeCheckingList.TypeCheckingListIterator itr = (TypeCheckingList.TypeCheckingListIterator)this.listIterator();
        PointerTargetTreeNodeList list = new PointerTargetTreeNodeList();
        while (itr.hasNext()) {
            PointerTargetNode node = (PointerTargetNode)itr.next();
            list.add(new PointerTargetTreeNode(node.getPointerTarget(), node.getType()));
        }
        return list;
    }

    public PointerTargetNodeList reverse() {
        try {
            PointerTargetNodeList clone = (PointerTargetNodeList)this.clone();
            Collections.reverse(clone);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new PointerTargetNodeList((LinkedList)this.copyBackingList());
    }

    @Override
    public Object deepClone() throws UnsupportedOperationException {
        PointerTargetNodeList list = new PointerTargetNodeList();
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            list.add(((PointerTargetNode)itr.next()).clone());
        }
        return list;
    }
}

