/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import de.julielab.jcore.types.Header;
import de.julielab.jcore.utility.JCoReUtilitiesException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.DataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JCoReTools {
    public static final int DEFAULT_ADDITION_SIZE = 10;
    private static final Logger log = LoggerFactory.getLogger(JCoReTools.class);

    public static FSArray addToFSArray(FSArray array, FeatureStructure newElement) {
        return JCoReTools.addToFSArray(array, newElement, 10);
    }

    public static FSArray addToFSArray(FSArray array, FeatureStructure newElement, int additionSize) {
        int lastElementIndex;
        assert (additionSize > 0);
        FSArray outputArray = array;
        if (null == outputArray) {
            try {
                outputArray = new FSArray(newElement.getCAS().getJCas(), 1);
            }
            catch (CASException e1) {
                throw new JCoReUtilitiesException(e1);
            }
        }
        if (outputArray.get(lastElementIndex = outputArray.size() - 1) != null) {
            log.trace("Last element of passed array was not null, thus array is full and a new one is created.");
            try {
                FSArray array2 = new FSArray(outputArray.getCAS().getJCas(), outputArray.size() + additionSize);
                array2.copyFromArray(outputArray.toArray(), 0, 0, outputArray.size());
                array2.set(lastElementIndex + 1, newElement);
                outputArray = array2;
                log.trace("New array is of size {}.", (Object)array2.size());
                return array2;
            }
            catch (CASException e) {
                e.printStackTrace();
            }
        } else {
            log.trace("There is still room left over in the passed array, new element is appended after the last non-null element.");
        }
        while (lastElementIndex > 0 && outputArray.get(lastElementIndex - 1) == null) {
            --lastElementIndex;
        }
        log.trace("Last non-null element was found on index {}, adding new element on position {}.", (Object)(lastElementIndex - 1), (Object)lastElementIndex);
        outputArray.set(lastElementIndex, newElement);
        return outputArray;
    }

    public static FSArray addToFSArray(FSArray inputArray, Collection<? extends FeatureStructure> newElements) {
        FSArray array = inputArray;
        if (null == newElements || newElements.size() == 0) {
            return array;
        }
        if (null == array) {
            try {
                array = new FSArray(newElements.iterator().next().getCAS().getJCas(), newElements.size());
            }
            catch (CASException e1) {
                throw new JCoReUtilitiesException(e1);
            }
        }
        try {
            int lastElementIndex;
            for (lastElementIndex = array.size() - 1; lastElementIndex >= 0 && array.get(lastElementIndex) == null; --lastElementIndex) {
            }
            FSArray ret = null;
            int requiredSpace = lastElementIndex + 1 + newElements.size();
            if (requiredSpace <= array.size()) {
                log.trace("Existing array has size {}. Since space for {} elements is required the passed array is kept.", (Object)array.size(), (Object)requiredSpace);
                ret = array;
            } else {
                log.trace("Passed array has size {} but there are {} elements overall, thus a new FSArray is created.", (Object)array.size(), (Object)requiredSpace);
                ret = new FSArray(array.getCAS().getJCas(), requiredSpace);
                for (int i = 0; i <= lastElementIndex; ++i) {
                    ret.set(i, array.get(i));
                }
            }
            int currentIndex = lastElementIndex + 1;
            Iterator<? extends FeatureStructure> it = newElements.iterator();
            while (it.hasNext()) {
                ret.set(currentIndex, it.next());
                ++currentIndex;
            }
            return ret;
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
    }

    public static FSArray copyFSArray(FSArray array) {
        FSArray output = null;
        try {
            output = new FSArray(array.getCAS().getJCas(), array.size());
            for (int i = 0; i < array.size(); ++i) {
                output.set(i, array.get(i));
            }
        }
        catch (CASException e) {
            throw new JCoReUtilitiesException(e);
        }
        return output;
    }

    public static StringArray newStringArray(JCas jCas, String ... elements) {
        int length = elements != null ? elements.length : 0;
        StringArray strings = new StringArray(jCas, elements.length);
        strings.copyFromArray(elements, 0, 0, elements.length);
        return strings;
    }

    public static StringArray addToStringArray(StringArray array, String element) {
        try {
            StringArray newArray = null;
            newArray = new StringArray(array.getCAS().getJCas(), array.size() + 1);
            newArray.copyFromArray(array.toArray(), 0, 0, array.size());
            newArray.set(newArray.size() - 1, element);
            return newArray;
        }
        catch (CASException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringArray addToStringArray(StringArray array, String[] elements) {
        if (null == elements) {
            return null;
        }
        try {
            StringArray newArray = new StringArray(array.getCAS().getJCas(), array.size() + elements.length);
            newArray.copyFromArray(array.toArray(), 0, 0, array.size());
            newArray.copyFromArray(elements, 0, array.size(), elements.length);
            return newArray;
        }
        catch (CASException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void printFSArray(FSArray array) {
        for (int i = 0; i < array.size(); ++i) {
            FeatureStructure fs = array.get(i);
            System.out.println("fs[" + i + "] =  " + fs);
        }
    }

    public static void printAnnotationIndex(JCas jCas, int type) {
        for (Annotation a : jCas.getAnnotationIndex(type)) {
            System.out.println("[" + a.getBegin() + "-" + a.getEnd() + "] " + a.getCoveredText());
        }
    }

    public static String getDocId(JCas aJCas) {
        AnnotationIndex headerIndex = aJCas.getAnnotationIndex(Header.type);
        Iterator it = headerIndex.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Header header = (Header)it.next();
        String pubmedId = header.getDocId();
        return pubmedId;
    }

    public static void deserializeXmi(CAS cas, InputStream is, int attributeBufferSize) throws SAXException, IOException {
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        InputSource source = new InputSource(reader);
        source.setEncoding("UTF-8");
        if (attributeBufferSize > 0) {
            System.setProperty("julielab.xerces.attributebuffersize", String.valueOf(attributeBufferSize));
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        XmiCasDeserializer deser = new XmiCasDeserializer(cas.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(cas, false, null, -1);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(source);
        System.clearProperty("julielab.xerces.attributebuffersize");
    }

    public static <T extends Annotation, R extends Comparable<R>> int binarySearch(List<T> annotations, Function<T, R> comparisonValueFunction, R searchValue) {
        return JCoReTools.binarySearch(annotations, comparisonValueFunction, searchValue, 0, annotations.size() - 1);
    }

    public static <T extends Annotation, R extends Comparable<R>> int binarySearch(List<T> annotations, Function<T, R> comparisonValueFunction, R searchValue, int from, int to) {
        assert (from <= to) : "End offset is smaller than begin offset";
        int lookupIndex = from + (to - from) / 2;
        Annotation annotation = (Annotation)annotations.get(lookupIndex);
        Comparable comparisonValue = (Comparable)comparisonValueFunction.apply(annotation);
        int comparison = searchValue.compareTo((Comparable)comparisonValue);
        if (comparison == 0) {
            return lookupIndex;
        }
        if (comparison < 0) {
            if (from > lookupIndex - 1) {
                return -lookupIndex - 1;
            }
            return JCoReTools.binarySearch(annotations, comparisonValueFunction, searchValue, from, lookupIndex - 1);
        }
        if (to < lookupIndex + 1) {
            return -(lookupIndex + 1) - 1;
        }
        return JCoReTools.binarySearch(annotations, comparisonValueFunction, searchValue, lookupIndex + 1, to);
    }

    public static InputStream resolveExternalResourceGzipInputStream(DataResource resource) throws IOException {
        if (resource == null) {
            throw new IllegalArgumentException("The passed DataResource is null.");
        }
        InputStream is = resource.getInputStream();
        if (is == null) {
            throw new IllegalArgumentException("The resource at " + resource.getUrl() + " could not be read. It does not exist or is not on the ClassPath.");
        }
        String lcUriString = resource.getUri().toString().toLowerCase();
        if (lcUriString.endsWith(".gz") || lcUriString.endsWith(".gzip")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }
}

