/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.util.Resolvable;

public final class POS
implements Serializable {
    static final long serialVersionUID = 4311120391558046419L;
    public static final POS NOUN = new POS("NOUN", "NOUN_KEY");
    public static final POS VERB = new POS("VERB", "VERB_KEY");
    public static final POS ADJECTIVE = new POS("ADJECTIVE", "ADJECTIVE_KEY");
    public static final POS ADVERB = new POS("ADVERB", "ADVERB_KEY");
    private static final List ALL_POS = Collections.unmodifiableList(Arrays.asList(NOUN, VERB, ADJECTIVE, ADVERB));
    private Resolvable _label;
    private Resolvable _key;
    private transient String _cachedToString = null;

    public static List getAllPOS() {
        return ALL_POS;
    }

    public static POS getPOSForLabel(String label) {
        for (POS pos : ALL_POS) {
            if (!pos.getLabel().equals(label)) continue;
            return pos;
        }
        return null;
    }

    public static POS getPOSForKey(String key) {
        for (POS pos : ALL_POS) {
            if (!pos.getKey().equals(key)) continue;
            return pos;
        }
        return null;
    }

    private POS(String label, String key) {
        this._label = new Resolvable(label);
        this._key = new Resolvable(key);
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_010", this.getLabel());
        }
        return this._cachedToString;
    }

    public int hashCode() {
        return this._key.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof POS) {
            POS pos = (POS)obj;
            return this._key.toString().equals(pos.getKey());
        }
        return false;
    }

    public String getLabel() {
        return this._label.toString();
    }

    public String getKey() {
        return this._key.toString();
    }
}

