/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.impl;

import java.util.Arrays;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public class JCasHashMap {
    private static final boolean TUNE = false;
    static int DEFAULT_CONCURRENCY_LEVEL;
    private static final int PROBE_ADDR_INDEX = 0;
    private static final int PROBE_DELTA_INDEX = 1;
    static final TOP_Type RESERVE_TOP_TYPE_INSTANCE;
    private final float loadFactor = 0.6f;
    private final int initialCapacity;
    private final boolean useCache;
    private final int concurrencyLevel;
    private final int concurrencyBitmask;
    private final int concurrencyLevelBits;
    private final SubMap[] subMaps;
    private final int subMapInitialCapacity;
    private final SubMap oneSubmap;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final int seed = 969059159;

    static int nextHigherPowerOf2(int i) {
        return i < 1 ? 1 : Integer.highestOneBit(i) << (Integer.bitCount(i) == 1 ? 0 : 1);
    }

    static int getDEFAULT_CONCURRENCY_LEVEL() {
        return DEFAULT_CONCURRENCY_LEVEL;
    }

    static void setDEFAULT_CONCURRENCY_LEVEL(int dEFAULT_CONCURRENCY_LEVEL) {
        DEFAULT_CONCURRENCY_LEVEL = JCasHashMap.nextHigherPowerOf2(dEFAULT_CONCURRENCY_LEVEL);
    }

    private static boolean isReserve(FeatureStructureImpl m) {
        return m != null && ((TOP)m).jcasType == RESERVE_TOP_TYPE_INSTANCE;
    }

    private static boolean isReal(FeatureStructureImpl m) {
        return m != null && ((TOP)m).jcasType != RESERVE_TOP_TYPE_INSTANCE;
    }

    private static int[] resetProbeInfo(int[] probeInfo) {
        probeInfo[0] = -1;
        probeInfo[1] = 1;
        return probeInfo;
    }

    private static int[] setProbeInfo(int[] probeInfo, int probeAddr, int probeDelta) {
        probeInfo[0] = probeAddr;
        probeInfo[1] = probeDelta;
        return probeInfo;
    }

    JCasHashMap(int capacity, boolean doUseCache) {
        this(capacity, doUseCache, capacity / DEFAULT_CONCURRENCY_LEVEL < 32 ? JCasHashMap.nextHigherPowerOf2(Math.max(1, capacity / 32)) : DEFAULT_CONCURRENCY_LEVEL);
    }

    JCasHashMap(int capacity, boolean doUseCache, int aConcurrencyLevel) {
        this.useCache = doUseCache;
        if (aConcurrencyLevel < 1 || capacity < 1) {
            throw new RuntimeException(String.format("capacity %d and concurrencyLevel %d must be > 0", capacity, aConcurrencyLevel));
        }
        this.concurrencyLevel = JCasHashMap.nextHigherPowerOf2(aConcurrencyLevel);
        this.concurrencyBitmask = this.concurrencyLevel - 1;
        this.concurrencyLevelBits = Integer.numberOfTrailingZeros(this.concurrencyLevel);
        if ((capacity = Math.max(32, JCasHashMap.nextHigherPowerOf2(capacity))) / this.concurrencyLevel < 32) {
            capacity = 32 * this.concurrencyLevel;
        }
        this.initialCapacity = capacity;
        this.subMaps = new SubMap[this.concurrencyLevel];
        this.subMapInitialCapacity = this.initialCapacity / this.concurrencyLevel;
        for (int i = 0; i < this.concurrencyLevel; ++i) {
            this.subMaps[i] = new SubMap().newTable(this.subMapInitialCapacity);
        }
        this.oneSubmap = this.concurrencyLevel == 1 ? this.subMaps[0] : null;
    }

    public synchronized void clear() {
        if (!this.useCache) {
            return;
        }
        for (SubMap m : this.subMaps) {
            m.clear();
        }
    }

    private SubMap getSubMap(int hash) {
        return null != this.oneSubmap ? this.oneSubmap : this.subMaps[hash & this.concurrencyBitmask];
    }

    public FeatureStructureImpl getReserve(int key) {
        if (!this.useCache) {
            return null;
        }
        int hash = this.hashInt(key);
        return this.getSubMap(hash).getReserve(key, hash >>> this.concurrencyLevelBits);
    }

    public FeatureStructureImpl put(FeatureStructureImpl value) {
        if (!this.useCache) {
            return null;
        }
        int key = value.getAddress();
        int hash = this.hashInt(key);
        return this.getSubMap(hash).put(key, value, hash >>> this.concurrencyLevelBits);
    }

    public int hashInt(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        int h1 = 0x39C2AB57 ^ (k1 *= 461845907);
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    int[] getCapacities() {
        int[] r = new int[this.subMaps.length];
        int i = 0;
        for (SubMap subMap : this.subMaps) {
            r[i++] = subMap.table.length;
        }
        return r;
    }

    int getCapacity() {
        int r = 0;
        for (SubMap subMap : this.subMaps) {
            r += subMap.table.length;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getApproximateSize() {
        int s = 0;
        SubMap[] arr$ = this.subMaps;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SubMap subMap;
            SubMap subMap2 = subMap = arr$[i$];
            synchronized (subMap2) {
                s += subMap.size;
                continue;
            }
        }
        return s;
    }

    public void showHistogram() {
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    static /* synthetic */ boolean access$300(FeatureStructureImpl x0) {
        return JCasHashMap.isReal(x0);
    }

    static {
        int cores = Runtime.getRuntime().availableProcessors();
        DEFAULT_CONCURRENCY_LEVEL = cores <= 1 ? 1 : (cores <= 4 ? 2 : (cores <= 32 ? 4 : (cores <= 128 ? 8 : 16)));
        RESERVE_TOP_TYPE_INSTANCE = new ReserveTopType();
    }

    private class SubMap {
        private int[] histogram;
        private int maxProbe = 0;
        private int maxProbeAfterContinue = 0;
        private int continues = 0;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition lockCondition = this.lock.newCondition();
        private int sizeWhichTriggersExpansion;
        private int size;
        private volatile FeatureStructureImpl[] table;
        private boolean secondTimeShrinkable = false;

        private SubMap() {
        }

        private SubMap newTable(int capacity) {
            this.table = this.newTableKeepSize(capacity);
            this.size = 0;
            return this;
        }

        private FeatureStructureImpl[] newTableKeepSize(int capacity) {
            assert (Integer.bitCount(capacity) == 1);
            FeatureStructureImpl[] t = new FeatureStructureImpl[capacity];
            this.sizeWhichTriggersExpansion = (int)((float)capacity * 0.6f);
            return t;
        }

        private void incrementSize() {
            assert (this.lock.getHoldCount() > 0);
            if (this.size >= this.sizeWhichTriggersExpansion) {
                this.increaseTableCapacity();
            }
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            this.lock.lock();
            try {
                if (this.size < this.sizeWhichTriggersExpansion >>> 1) {
                    if (this.secondTimeShrinkable) {
                        this.secondTimeShrinkable = false;
                        int newCapacity = Math.max(JCasHashMap.this.subMapInitialCapacity, this.table.length >>> 1);
                        if (newCapacity < this.table.length) {
                            this.newTable(newCapacity);
                        } else {
                            Arrays.fill(this.table, null);
                        }
                        this.size = 0;
                        return;
                    }
                    this.secondTimeShrinkable = true;
                } else {
                    this.secondTimeShrinkable = false;
                }
                this.size = 0;
                Arrays.fill(this.table, null);
            }
            finally {
                this.lock.unlock();
            }
        }

        private FeatureStructureImpl find(int key, int hash, int[] probeInfo) {
            int probeAddr;
            int nbrProbes = 1;
            boolean isContinue = false;
            FeatureStructureImpl[] localTable = this.table;
            int bitMask = localTable.length - 1;
            int startProbe = probeInfo[0];
            int n = probeAddr = startProbe < 0 ? hash & bitMask : startProbe;
            assert (startProbe >= 0 || probeInfo[1] == 1);
            int probeDelta = probeInfo[1];
            FeatureStructureImpl m = localTable[probeAddr];
            while (null != m) {
                if (m.getAddress() == key) {
                    JCasHashMap.setProbeInfo(probeInfo, probeAddr, probeDelta);
                    return m;
                }
                ++nbrProbes;
                probeAddr = bitMask & probeAddr + probeDelta++;
                m = localTable[probeAddr];
            }
            JCasHashMap.setProbeInfo(probeInfo, probeAddr, probeDelta);
            return m;
        }

        /*
         * Exception decompiling
         */
        private FeatureStructureImpl getReserve(int key, int hash) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 9[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FeatureStructureImpl put(int key, FeatureStructureImpl value, int hash) {
            this.lock.lock();
            try {
                int[] probeInfo = JCasHashMap.resetProbeInfo(new int[2]);
                FeatureStructureImpl prevValue = this.find(key, hash, probeInfo);
                this.table[probeInfo[0]] = value;
                if (JCasHashMap.isReserve(prevValue)) {
                    this.lockCondition.signalAll();
                    FeatureStructureImpl featureStructureImpl = null;
                    return featureStructureImpl;
                }
                if (prevValue == null) {
                    this.incrementSize();
                }
                FeatureStructureImpl featureStructureImpl = prevValue;
                return featureStructureImpl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void putInner(int key, FeatureStructureImpl value, int hash) {
            assert (this.lock.getHoldCount() > 0);
            int[] probeInfo = JCasHashMap.resetProbeInfo(new int[2]);
            FeatureStructureImpl m = this.find(key, hash, probeInfo);
            assert (m == null);
            this.table[probeInfo[0]] = value;
        }

        private void increaseTableCapacity() {
            FeatureStructureImpl[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            int newCapacity = 2 * oldCapacity;
            this.table = this.newTableKeepSize(newCapacity);
            for (int i = 0; i < oldCapacity; ++i) {
                FeatureStructureImpl fs = oldTable[i];
                if (fs == null) continue;
                int key = fs.getAddress();
                int hash = JCasHashMap.this.hashInt(key);
                this.putInner(key, fs, hash >>> JCasHashMap.this.concurrencyLevelBits);
            }
        }
    }

    private static class ReserveTopType
    extends TOP_Type {
    }
}

