/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.CommonArray_Type;
import org.apache.uima.jcas.cas.TOP;

public final class ByteArray_Type
extends CommonArray_Type {
    public static final int typeIndexID = ByteArray.typeIndexID;
    private final FSGenerator fsGenerator = new FSGenerator(){

        @Override
        public FeatureStructure createFS(int addr, CASImpl cas) {
            if (ByteArray_Type.this.useExistingInstance) {
                TOP fs = ByteArray_Type.this.jcas.getJfsFromCaddr(addr);
                if (null == fs) {
                    fs = new ByteArray(addr, ByteArray_Type.this);
                    ByteArray_Type.this.jcas.putJfsFromCaddr(addr, fs);
                    return fs;
                }
                return fs;
            }
            return new ByteArray(addr, ByteArray_Type.this);
        }
    };

    @Override
    protected FSGenerator getFSGenerator() {
        return this.fsGenerator;
    }

    private ByteArray_Type() {
    }

    public ByteArray_Type(JCas jcas, Type casType) {
        super(jcas, casType);
        this.casImpl.getFSClassRegistry().addGeneratorForType((TypeImpl)this.casType, this.getFSGenerator());
    }

    public byte get(int addr, int i) {
        if (this.lowLevelTypeChecks) {
            return this.ll_cas.ll_getByteArrayValue(addr, i, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        return this.ll_cas.ll_getByteArrayValue(addr, i);
    }

    public void set(int addr, int i, byte v) {
        if (this.lowLevelTypeChecks) {
            this.ll_cas.ll_setByteArrayValue(addr, i, v, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        this.ll_cas.ll_setByteArrayValue(addr, i, v);
    }

    public void copyFromArray(int addr, byte[] src, int srcOffset, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, destOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            this.ll_cas.ll_setByteArrayValue(addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int addr, int srcOffset, byte[] dest, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, srcOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.ll_cas.ll_getByteArrayValue(addr, i + srcOffset);
        }
    }

    public byte[] toArray(int addr) {
        int size = this.size(addr);
        byte[] outArray = new byte[size];
        this.copyToArray(addr, 0, outArray, 0, size);
        return outArray;
    }
}

