/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import org.apache.uima.internal.util.IntArrayUtils;
import org.apache.uima.internal.util.StringUtils;

public class IntArrayRBTcommon {
    protected static final boolean useklrp = true;
    protected int[] key;
    protected int[] left;
    protected int[] right;
    protected int[] parent;
    protected int[] klrp;
    protected int[] klrp1;
    protected int[] klrp2;
    protected int[] klrp3;
    protected static final int MAXklrp0 = 0x20000000;
    protected static final int MAXklrpMask = 0x1FFFFFFF;
    protected boolean[] color;
    protected int next;
    protected int size;
    protected int root;
    protected int greatestNode;
    protected static final int default_size = 1024;
    protected final int initialSize;
    protected final int growth_factor = 2;
    protected final int multiplication_limit = 0x200000;
    public static final int NIL = 0;
    protected static final boolean red = true;
    protected static final boolean black = false;

    protected int getXXX(int node, int offset) {
        if (node < 0x20000000) {
            return this.klrp[(node << 2) + offset];
        }
        int w = node >> 29;
        int i = ((node & 0x1FFFFFFF) << 2) + offset;
        switch (w) {
            case 1: {
                return this.klrp1[i];
            }
            case 2: {
                return this.klrp2[i];
            }
            case 3: {
                return this.klrp3[i];
            }
        }
        throw new RuntimeException();
    }

    protected int setXXX(int node, int offset, int value) {
        if (node < 0x20000000) {
            int n = value;
            this.klrp[(node << 2) + offset] = n;
            return n;
        }
        int w = node >> 29;
        int i = ((node & 0x1FFFFFFF) << 2) + offset;
        switch (w) {
            case 1: {
                this.klrp1[i] = value;
                return this.klrp1[i];
            }
            case 2: {
                this.klrp2[i] = value;
                return this.klrp2[i];
            }
            case 3: {
                this.klrp3[i] = value;
                return this.klrp3[i];
            }
        }
        throw new RuntimeException();
    }

    protected int getKey(int node) {
        return this.getXXX(node, 0);
    }

    protected int setKey(int node, int value) {
        return this.setXXX(node, 0, value);
    }

    protected int getLeft(int node) {
        return this.getXXX(node, 1);
    }

    protected int setLeft(int node, int value) {
        return this.setXXX(node, 1, value);
    }

    protected int getRight(int node) {
        return this.getXXX(node, 2);
    }

    protected int setRight(int node, int value) {
        return this.setXXX(node, 2, value);
    }

    protected int getParent(int node) {
        return this.getXXX(node, 3);
    }

    protected int setParent(int node, int value) {
        return this.setXXX(node, 3, value);
    }

    public IntArrayRBTcommon() {
        this(1024);
    }

    public IntArrayRBTcommon(int initialSize) {
        if (initialSize < 4) {
            initialSize = 4;
        }
        this.initVars();
        this.initialSize = this.nextPowerOf2(initialSize);
        this.setupArrays();
    }

    protected int nextPowerOf2(int v) {
        int v2 = Integer.highestOneBit(v);
        return v2 < v ? v2 << 1 : v2;
    }

    protected void setupArrays() {
        this.klrp = new int[this.initialSize << 2];
        this.color = new boolean[this.initialSize];
        this.setLeft(0, 0);
        this.setRight(0, 0);
        this.setParent(0, 0);
        this.color[0] = false;
    }

    protected void initVars() {
        this.root = 0;
        this.greatestNode = 0;
        this.next = 1;
        this.size = 0;
    }

    public void flush() {
        this.initVars();
        if (this.klrp.length > this.initialSize << 2) {
            this.setupArrays();
        }
    }

    public final int size() {
        return this.size;
    }

    protected void ensureCapacityKlrp(int requiredSize) {
        int w = requiredSize >> 29;
        int requiredCapacityForLastSegment = Math.max(1024, requiredSize - w * 0x20000000);
        switch (w) {
            case 3: {
                this.klrp3 = this.klrp3 == null ? new int[requiredCapacityForLastSegment << 2] : this.ensureArrayCapacity(this.klrp3, requiredCapacityForLastSegment << 2);
                this.maximize(this.klrp2);
                this.maximize(this.klrp1);
                this.maximize(this.klrp);
                break;
            }
            case 2: {
                this.klrp2 = this.klrp2 == null ? new int[requiredCapacityForLastSegment << 2] : this.ensureArrayCapacity(this.klrp2, requiredCapacityForLastSegment << 2);
                this.maximize(this.klrp1);
                this.maximize(this.klrp);
                break;
            }
            case 1: {
                this.klrp1 = this.klrp1 == null ? new int[requiredCapacityForLastSegment << 2] : this.ensureArrayCapacity(this.klrp1, requiredCapacityForLastSegment << 2);
                this.maximize(this.klrp);
                break;
            }
            case 0: {
                this.klrp = this.ensureArrayCapacity(this.klrp, requiredCapacityForLastSegment << 2);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void ensureCapacityNotKrlp(int requiredSize) {
        this.key = this.ensureArrayCapacity(this.key, requiredSize);
        this.left = this.ensureArrayCapacity(this.left, requiredSize);
        this.right = this.ensureArrayCapacity(this.right, requiredSize);
        this.parent = this.ensureArrayCapacity(this.parent, requiredSize);
    }

    protected void ensureCapacity(int requiredSize) {
        this.color = this.ensureBooleanArraySize(this.color, requiredSize);
    }

    private int[] maximize(int[] array) {
        if (array.length < 0x20000000) {
            int[] a = new int[0x20000000];
            System.arraycopy(array, 0, a, 0, array.length);
            return a;
        }
        return array;
    }

    protected int newNode(int k) {
        int lenKlrp = this.klrp.length >> 2;
        if (this.klrp1 != null) {
            lenKlrp += this.klrp1.length >> 2;
            if (this.klrp2 != null) {
                lenKlrp += this.klrp2.length >> 2;
                if (this.klrp3 != null) {
                    lenKlrp += this.klrp3.length >> 2;
                }
            }
        }
        if (this.next >= lenKlrp) {
            this.ensureCapacityKlrp(this.next + 1);
        }
        if (this.next >= this.color.length) {
            this.ensureCapacity(this.next + 1);
        }
        int z = this.next++;
        ++this.size;
        this.setKey(z, k);
        this.setLeft(z, 0);
        this.setRight(z, 0);
        this.color[z] = true;
        return z;
    }

    protected final void setAsRoot(int x) {
        this.root = x;
        this.setParent(this.root, 0);
    }

    protected final int[] ensureArrayCapacity(int[] array, int newSize) {
        return IntArrayUtils.ensure_size(array, newSize, this.growth_factor, this.multiplication_limit);
    }

    private final boolean[] ensureBooleanArraySize(boolean[] array, int newSize) {
        return IntArrayUtils.ensure_size(array, newSize, this.growth_factor, this.multiplication_limit * 32);
    }

    protected final void leftRotate(int x) {
        int y = this.getRight(x);
        int left_of_y = this.getLeft(y);
        this.setRight(x, left_of_y);
        if (left_of_y != 0) {
            this.setParent(left_of_y, x);
        }
        this.setParent(y, this.getParent(x));
        if (this.root == x) {
            this.setAsRoot(y);
        } else {
            int parent_x = this.getParent(x);
            if (x == this.getLeft(parent_x)) {
                this.setLeft(parent_x, y);
            } else {
                this.setRight(parent_x, y);
            }
        }
        this.setLeft(y, x);
        this.setParent(x, y);
    }

    protected final void rightRotate(int x) {
        int y = this.getLeft(x);
        int right_y = this.getRight(y);
        this.setLeft(x, right_y);
        if (right_y != 0) {
            this.setParent(right_y, x);
        }
        int parent_x = this.getParent(x);
        this.setParent(y, parent_x);
        if (this.root == x) {
            this.setAsRoot(y);
        } else if (x == this.getRight(parent_x)) {
            this.setRight(parent_x, y);
        } else {
            this.setLeft(parent_x, y);
        }
        this.setRight(y, x);
        this.setParent(x, y);
    }

    protected int findKey(int k) {
        return this.findKeyDown(k, this.root);
    }

    protected int findKeyDown(int k, int node) {
        while (node != 0) {
            int keyNode = this.getKey(node);
            if (k < keyNode) {
                node = this.getLeft(node);
                continue;
            }
            if (k == keyNode) {
                return node;
            }
            node = this.getRight(node);
        }
        return 0;
    }

    public int findInsertionPointNoDups(int k) {
        int node;
        int found = node = this.root;
        while (node != 0) {
            found = node;
            int keyNode = this.getKey(node);
            if (k < keyNode) {
                node = this.getLeft(node);
                continue;
            }
            if (k == keyNode) {
                return node;
            }
            node = this.getRight(node);
        }
        return found;
    }

    public final boolean containsKey(int k) {
        return this.findKey(k) != 0;
    }

    public final boolean contains(int k) {
        return this.findKey(k) != 0;
    }

    protected final int getFirstNode() {
        int left_node;
        if (this.root == 0) {
            return 0;
        }
        int node = this.root;
        while ((left_node = this.getLeft(node)) != 0) {
            node = left_node;
        }
        return node;
    }

    protected final int nextNode(int node) {
        int rightNode = this.getRight(node);
        if (rightNode != 0) {
            int leftNode;
            node = rightNode;
            while ((leftNode = this.getLeft(node)) != 0) {
                node = leftNode;
            }
        } else {
            int y = this.getParent(node);
            while (y != 0 && node == this.getRight(y)) {
                node = y;
                y = this.getParent(y);
            }
            node = y;
        }
        return node;
    }

    protected final int previousNode(int node) {
        int leftNode = this.getLeft(node);
        if (leftNode != 0) {
            int rightNode;
            node = leftNode;
            while ((rightNode = this.getRight(node)) != 0) {
                node = rightNode;
            }
        } else {
            while (true) {
                int parentNode = this.getParent(node);
                if (node == this.root || node != this.getLeft(parentNode)) break;
                node = parentNode;
            }
            if (node == this.root) {
                return 0;
            }
            node = this.getParent(node);
        }
        return node;
    }

    protected void deleteNode(int z) {
        int y = this.getLeft(z) == 0 || this.getRight(z) == 0 ? z : this.nextNode(z);
        int left_y = this.getLeft(y);
        int x = left_y != 0 ? left_y : this.getRight(y);
        int parent_y = this.getParent(y);
        this.setParent(x, parent_y);
        if (parent_y == 0) {
            this.setAsRoot(x);
        } else if (y == this.getLeft(parent_y)) {
            this.setLeft(parent_y, x);
        } else {
            this.setRight(parent_y, x);
        }
        if (y != z) {
            this.setKey(z, this.getKey(y));
        }
        if (!this.color[y]) {
            this.deleteFixup(x);
        }
    }

    protected void deleteFixup(int x) {
        while (x != this.root && !this.color[x]) {
            int w;
            int parent_x = this.getParent(x);
            if (x == this.getLeft(parent_x)) {
                w = this.getRight(parent_x);
                if (this.color[w]) {
                    this.color[w] = false;
                    this.color[parent_x] = true;
                    this.leftRotate(parent_x);
                    w = this.getRight(parent_x);
                }
                if (!this.color[this.getLeft(w)] && !this.color[this.getRight(w)]) {
                    this.color[w] = true;
                    x = parent_x;
                    continue;
                }
                if (!this.color[this.getRight(w)]) {
                    this.color[this.getLeft((int)w)] = false;
                    this.color[w] = true;
                    this.rightRotate(w);
                    w = this.getRight(parent_x);
                }
                this.color[w] = this.color[parent_x];
                this.color[parent_x] = false;
                this.color[this.getRight((int)w)] = false;
                this.leftRotate(parent_x);
                x = this.root;
                continue;
            }
            w = this.getLeft(parent_x);
            if (this.color[w]) {
                this.color[w] = false;
                this.color[parent_x] = true;
                this.rightRotate(parent_x);
                w = this.getLeft(parent_x);
            }
            if (!this.color[this.getLeft(w)] && !this.color[this.getRight(w)]) {
                this.color[w] = true;
                x = this.getParent(x);
                continue;
            }
            if (!this.color[this.getLeft(w)]) {
                this.color[this.getRight((int)w)] = false;
                this.color[w] = true;
                this.leftRotate(w);
                w = this.getLeft(this.getParent(x));
            }
            this.color[w] = this.color[parent_x];
            this.color[parent_x] = false;
            this.color[this.getLeft((int)w)] = false;
            this.rightRotate(parent_x);
            x = this.root;
        }
        this.color[x] = false;
    }

    public boolean satisfiesRedBlackProperties() {
        int node = this.root;
        int blackDepth = 0;
        while (node != 0) {
            if (!this.color[node]) {
                ++blackDepth;
            }
            node = this.getLeft(node);
        }
        return this.satisfiesRBProps(this.root, blackDepth, 0);
    }

    protected boolean satisfiesRBProps(int node, int blackDepth, int currentBlack) {
        if (node == 0) {
            return currentBlack == blackDepth;
        }
        if (this.color[node]) {
            if (this.color[this.getLeft(node)] || this.color[this.getRight(node)]) {
                return false;
            }
        } else {
            ++currentBlack;
        }
        return this.satisfiesRBProps(this.getLeft(node), blackDepth, currentBlack) && this.satisfiesRBProps(this.getRight(node), blackDepth, currentBlack);
    }

    public int maxDepth() {
        return this.maxDepth(this.root, 0);
    }

    public int minDepth() {
        return this.minDepth(this.root, 0);
    }

    public int nodeDepth(int k) {
        return this.nodeDepth(this.root, 1, k);
    }

    protected int nodeDepth(int node, int depth, int k) {
        if (node == 0) {
            return -1;
        }
        if (k == this.getKey(node)) {
            return depth;
        }
        if (k < this.getKey(node)) {
            return this.nodeDepth(this.getLeft(node), depth + 1, k);
        }
        return this.nodeDepth(this.getRight(node), depth + 1, k);
    }

    protected int maxDepth(int node, int depth) {
        int depth2;
        if (node == 0) {
            return depth;
        }
        int depth1 = this.maxDepth(this.getLeft(node), depth + 1);
        return depth1 > (depth2 = this.maxDepth(this.getRight(node), depth + 1)) ? depth1 : depth2;
    }

    protected int minDepth(int node, int depth) {
        int depth2;
        if (node == 0) {
            return depth;
        }
        int depth1 = this.maxDepth(this.getLeft(node), depth + 1);
        return depth1 > (depth2 = this.maxDepth(this.getRight(node), depth + 1)) ? depth2 : depth1;
    }

    public final void printKeys() {
        if (this.size() == 0) {
            System.out.println("Tree is empty.");
            return;
        }
        StringBuffer buf = new StringBuffer();
        this.printKeys(this.root, 0, buf);
        System.out.println(buf);
    }

    protected final void printKeys(int node, int offset, StringBuffer buf) {
        if (node == 0) {
            return;
        }
        StringUtils.printSpaces(offset, buf);
        buf.append(Integer.toString(this.getKey(node)));
        if (!this.color[node]) {
            buf.append(" BLACK");
        }
        buf.append("\n");
        this.printKeys(this.getLeft(node), offset + 2, buf);
        this.printKeys(this.getRight(node), offset + 2, buf);
    }
}

