/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Level;

public class ResourcePool {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<ResourcePool> CLASS_NAME = ResourcePool.class;
    private Vector<Resource> mAllInstances = new Vector();
    private Vector<Resource> mFreeInstances = new Vector();
    private int mNumInstances;
    private ResourceMetaData mMetaData;

    public ResourcePool(int aNumInstances, ResourceSpecifier aResourceSpecifier, Class<? extends Resource> aResourceClass) throws ResourceInitializationException {
        this(aNumInstances, aResourceSpecifier, aResourceClass, null);
    }

    public ResourcePool(int aNumInstances, ResourceSpecifier aResourceSpecifier, Class<? extends Resource> aResourceClass, Map<String, Object> aResourceInitParams) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aResourceSpecifier, aResourceClass, aResourceInitParams);
    }

    public synchronized Resource getResource() {
        if (!this.mFreeInstances.isEmpty()) {
            Resource r = this.mFreeInstances.remove(0);
            return r;
        }
        return null;
    }

    public synchronized void releaseResource(Resource aResource) {
        if (!this.mAllInstances.contains(aResource) || this.mFreeInstances.contains(aResource)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseResource", LOG_RESOURCE_BUNDLE, "UIMA_return_resource_to_pool__WARNING");
        } else {
            this.mFreeInstances.add(aResource);
        }
        this.notifyAll();
    }

    public synchronized Resource getResource(long aTimeout) {
        Resource resource;
        long startTime = new Date().getTime();
        while ((resource = this.getResource()) == null) {
            try {
                this.wait(aTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (aTimeout <= 0L || new Date().getTime() - startTime < aTimeout) continue;
            return null;
        }
        return resource;
    }

    public synchronized void checkoutSpecificResource(Resource r) {
        while (!this.mFreeInstances.contains(r)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mFreeInstances.remove(r);
    }

    public synchronized void destroy() {
        for (Resource current : this.mAllInstances) {
            current.destroy();
        }
        this.mAllInstances.clear();
        this.mFreeInstances.clear();
    }

    public int getSize() {
        return this.mNumInstances;
    }

    public ResourceMetaData getMetaData() {
        return this.mMetaData;
    }

    protected void fillPool(ResourceSpecifier aResourceSpecifier, Class<? extends Resource> aResourceClass, Map<String, Object> aResourceInitParams) throws ResourceInitializationException {
        for (int i = 0; i < this.mNumInstances; ++i) {
            Resource_ImplBase resource = (Resource_ImplBase)UIMAFramework.produceResource(aResourceClass, aResourceSpecifier, aResourceInitParams);
            this.mAllInstances.add(resource);
            this.mFreeInstances.add(resource);
            if (i != 0) continue;
            this.mMetaData = resource.getMetaData();
        }
    }

    protected Vector<Resource> getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector<Resource> getFreeInstances() {
        return this.mFreeInstances;
    }
}

