/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCasUtil {
    private JCasUtil() {
    }

    public static <T extends Annotation> Iterable<T> subiterate(JCas jCas, final Class<T> type, final AnnotationFS container, final boolean ambiguous, final boolean strict) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JCasUtil.iterator(container, type, ambiguous, strict);
            }
        };
    }

    public static <T extends TOP> Iterator<T> iterator(JCas jCas, Class<T> type) {
        return FSCollectionFactory.create(jCas.getCas(), JCasUtil.getType(jCas, type)).iterator();
    }

    public static <T extends AnnotationFS> Iterator<T> iterator(AnnotationFS container, Class<T> type, boolean ambiguous, boolean strict) {
        CAS cas = container.getCAS();
        return cas.getAnnotationIndex(CasUtil.getType(cas, type)).subiterator(container, ambiguous, strict);
    }

    public static Type getType(JCas jCas, Class<?> type) {
        return CasUtil.getType(jCas.getCas(), type);
    }

    public static Type getAnnotationType(JCas jCas, Class<?> type) {
        return CasUtil.getAnnotationType(jCas.getCas(), type);
    }

    public static <T extends TOP> Collection<T> select(FSArray array, Class<T> type) {
        return JCasUtil.cast(CasUtil.selectFS(array, CasUtil.getType(array.getCAS(), type.getName())));
    }

    public static <T extends TOP> Collection<T> select(FSList list, Class<T> type) {
        return JCasUtil.cast(FSCollectionFactory.create(list, CasUtil.getType(list.getCAS(), type.getName())));
    }

    public static <T extends TOP> Collection<T> select(JCas jCas, Class<T> type) {
        return JCasUtil.cast(CasUtil.selectFS(jCas.getCas(), JCasUtil.getType(jCas, type)));
    }

    public static Collection<TOP> selectAll(JCas jCas) {
        return JCasUtil.select(jCas, TOP.class);
    }

    public static <T extends Annotation> List<T> selectBetween(Class<T> type, AnnotationFS ann1, AnnotationFS ann2) {
        return JCasUtil.cast(CasUtil.selectBetween(CasUtil.getType(ann1.getCAS(), type), ann1, ann2));
    }

    public static <T extends Annotation> List<T> selectBetween(JCas jCas, Class<T> type, AnnotationFS ann1, AnnotationFS ann2) {
        return JCasUtil.cast(CasUtil.selectBetween(jCas.getCas(), JCasUtil.getType(jCas, type), ann1, ann2));
    }

    public static <T extends AnnotationFS> List<T> selectCovered(Class<T> type, AnnotationFS coveringAnnotation) {
        return JCasUtil.cast(CasUtil.selectCovered(CasUtil.getType(coveringAnnotation.getCAS(), type), coveringAnnotation));
    }

    public static <T extends Annotation> List<T> selectCovered(JCas jCas, Class<T> type, AnnotationFS coveringAnnotation) {
        return JCasUtil.cast(CasUtil.selectCovered(jCas.getCas(), JCasUtil.getType(jCas, type), coveringAnnotation));
    }

    public static <T extends Annotation> List<T> selectCovered(JCas jCas, Class<T> type, int begin, int end) {
        return JCasUtil.cast(CasUtil.selectCovered(jCas.getCas(), JCasUtil.getType(jCas, type), begin, end));
    }

    public static <T extends Annotation> List<T> selectCovering(Class<T> type, AnnotationFS coveredAnnotation) {
        return JCasUtil.cast(CasUtil.selectCovering(CasUtil.getType(coveredAnnotation.getCAS(), type), coveredAnnotation));
    }

    public static <T extends Annotation> List<T> selectCovering(JCas jCas, Class<T> type, AnnotationFS coveredAnnotation) {
        return JCasUtil.cast(CasUtil.selectCovering(jCas.getCas(), JCasUtil.getType(jCas, type), coveredAnnotation));
    }

    public static <T extends Annotation> List<T> selectCovering(JCas jCas, Class<T> type, int begin, int end) {
        return JCasUtil.cast(CasUtil.selectCovering(jCas.getCas(), JCasUtil.getType(jCas, type), begin, end));
    }

    public static <T extends Annotation, S extends Annotation> Map<T, Collection<S>> indexCovering(JCas jCas, Class<T> type, Class<S> coveringType) {
        return JCasUtil.cast(CasUtil.indexCovering(jCas.getCas(), JCasUtil.getType(jCas, type), JCasUtil.getType(jCas, coveringType)));
    }

    public static <T extends Annotation, S extends Annotation> Map<T, Collection<S>> indexCovered(JCas jCas, Class<T> type, Class<S> coveredType) {
        return JCasUtil.cast(CasUtil.indexCovered(jCas.getCas(), JCasUtil.getType(jCas, type), JCasUtil.getType(jCas, coveredType)));
    }

    public static boolean contains(JCas jCas, AnnotationFS coveringAnnotation, Class<? extends Annotation> type) {
        return JCasUtil.selectCovered(jCas, type, coveringAnnotation).size() > 0;
    }

    public static <T extends Annotation> T selectByIndex(JCas jCas, Class<T> cls, int index) {
        return (T)((Annotation)CasUtil.selectByIndex(jCas.getCas(), JCasUtil.getType(jCas, cls), index));
    }

    public static <T extends TOP> T selectSingle(JCas jCas, Class<T> type) {
        return (T)((TOP)CasUtil.selectSingle(jCas.getCas(), JCasUtil.getType(jCas, type)));
    }

    public static <T extends Annotation> T selectSingleRelative(Class<T> aType, AnnotationFS annotation, int index) {
        CAS cas = annotation.getCAS();
        Type t = CasUtil.getType(cas, aType);
        return (T)((Annotation)CasUtil.selectSingleRelative(cas, t, annotation, index));
    }

    public static <T extends Annotation> T selectSingleRelative(JCas aJCas, Class<T> aType, AnnotationFS annotation, int index) {
        Type t = JCasUtil.getType(aJCas, aType);
        return (T)((Annotation)CasUtil.selectSingleRelative(aJCas.getCas(), t, annotation, index));
    }

    public static <T extends Annotation> List<T> selectPreceding(Class<T> aType, AnnotationFS annotation, int count) {
        Type t = CasUtil.getType(annotation.getCAS(), aType);
        return JCasUtil.cast(CasUtil.selectPreceding(annotation.getView(), t, annotation, count));
    }

    public static <T extends Annotation> List<T> selectPreceding(JCas aJCas, Class<T> aType, AnnotationFS annotation, int count) {
        Type t = JCasUtil.getType(aJCas, aType);
        return JCasUtil.cast(CasUtil.selectPreceding(aJCas.getCas(), t, annotation, count));
    }

    public static <T extends Annotation> List<T> selectFollowing(Class<T> aType, AnnotationFS annotation, int count) {
        Type t = CasUtil.getType(annotation.getCAS(), aType);
        return JCasUtil.cast(CasUtil.selectFollowing(annotation.getView(), t, annotation, count));
    }

    public static <T extends Annotation> List<T> selectFollowing(JCas aJCas, Class<T> aType, AnnotationFS annotation, int count) {
        Type t = JCasUtil.getType(aJCas, aType);
        return JCasUtil.cast(CasUtil.selectFollowing(aJCas.getCas(), t, annotation, count));
    }

    public static <T extends TOP> boolean exists(JCas aJCas, Class<T> aType) {
        return JCasUtil.iterator(aJCas, aType).hasNext();
    }

    public static JCas getView(JCas jcas, String viewName, JCas fallback) {
        try {
            CAS fallbackCas = fallback != null ? fallback.getCas() : null;
            CAS view = CasUtil.getView(jcas.getCas(), viewName, fallbackCas);
            return view != null ? view.getJCas() : null;
        }
        catch (CASException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JCas getView(JCas jcas, String viewName, boolean create) {
        try {
            CAS view = CasUtil.getView(jcas.getCas(), viewName, create);
            return view != null ? view.getJCas() : null;
        }
        catch (CASException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends AnnotationFS> List<String> toText(Iterable<T> iterable) {
        return CasUtil.toText(iterable);
    }

    private static <T> Collection<T> cast(Collection aCollection) {
        return aCollection;
    }

    private static <T> List<T> cast(List aCollection) {
        return aCollection;
    }

    private static <K, V> Map<K, V> cast(Map aCollection) {
        return aCollection;
    }
}

