/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.factory;

import java.util.ArrayList;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenBuilder<TOKEN_TYPE extends Annotation, SENTENCE_TYPE extends Annotation> {
    private Class<TOKEN_TYPE> tokenClass;
    private Class<SENTENCE_TYPE> sentenceClass;
    private String posFeatureName;
    private String stemFeatureName;

    public TokenBuilder(Class<TOKEN_TYPE> aTokenClass, Class<SENTENCE_TYPE> aSentenceClass) {
        this(aTokenClass, aSentenceClass, null, null);
    }

    public TokenBuilder(Class<TOKEN_TYPE> aTokenClass, Class<SENTENCE_TYPE> aSentenceClass, String aPosFeatureName, String aStemFeatureName) {
        this.tokenClass = aTokenClass;
        this.sentenceClass = aSentenceClass;
        this.setPosFeatureName(aPosFeatureName);
        this.setStemFeatureName(aStemFeatureName);
    }

    public static <T extends Annotation, S extends Annotation> TokenBuilder<T, S> create(Class<T> aTokenClass, Class<S> aSentenceClass) {
        return new TokenBuilder<T, S>(aTokenClass, aSentenceClass);
    }

    public void setPosFeatureName(String aPosFeatureName) {
        this.posFeatureName = aPosFeatureName;
    }

    public void setStemFeatureName(String aStemFeatureName) {
        this.stemFeatureName = aStemFeatureName;
    }

    public void buildTokens(JCas aJCas, String aText) {
        if (aText == null) {
            throw new IllegalArgumentException("text may not be null.");
        }
        this.buildTokens(aJCas, aText, aText, null, null);
    }

    public void buildTokens(JCas aJCas, String aText, String aTokensString) {
        if (aTokensString == null) {
            throw new IllegalArgumentException("tokensString may not be null.");
        }
        this.buildTokens(aJCas, aText, aTokensString, null, null);
    }

    public void buildTokens(JCas aJCas, String aText, String aTokensString, String aPosTagsString) {
        this.buildTokens(aJCas, aText, aTokensString, aPosTagsString, null);
    }

    public void buildTokens(JCas aJCas, String aText, String aTokensString, String aPosTagsString, String aStemsString) {
        aJCas.setDocumentText(aText);
        if (aPosTagsString != null && this.posFeatureName == null) {
            throw new IllegalArgumentException("posTagsString must be null if TokenBuilder is not initialized with a feature name corresponding to the part-of-speech feature of the token type (assuming your token type has such a feature).");
        }
        if (aStemsString != null && this.stemFeatureName == null) {
            throw new IllegalArgumentException("stemsString must be null if TokenBuilder is not initialized with a feature name corresponding to the part-of-speech feature of the token type (assuming your token type has such a feature).");
        }
        Feature posFeature = null;
        if (this.posFeatureName != null) {
            posFeature = aJCas.getTypeSystem().getType(this.tokenClass.getName()).getFeatureByBaseName(this.posFeatureName);
        }
        Feature stemFeature = null;
        if (this.stemFeatureName != null) {
            stemFeature = aJCas.getTypeSystem().getType(this.tokenClass.getName()).getFeatureByBaseName(this.stemFeatureName);
        }
        String tokensString = aTokensString.replaceAll("\\s*\n\\s*", "\n");
        String[] sentenceStrings = tokensString.split("\n");
        String[] posTags = aPosTagsString != null ? aPosTagsString.split("\\s+") : null;
        String[] stems = aStemsString != null ? aStemsString.split("\\s+") : null;
        int offset = 0;
        int tokenIndex = 0;
        for (String sentenceString : sentenceStrings) {
            String[] tokenStrings = sentenceString.trim().split("\\s+");
            ArrayList<TOKEN_TYPE> tokenAnnotations = new ArrayList<TOKEN_TYPE>();
            for (String tokenString : tokenStrings) {
                while (!aText.startsWith(tokenString, offset)) {
                    if (++offset <= aText.length()) continue;
                    throw new IllegalArgumentException(String.format("unable to find string %s", tokenString));
                }
                int start = offset;
                TOKEN_TYPE token = AnnotationFactory.createAnnotation(aJCas, start, offset += tokenString.length(), this.tokenClass);
                tokenAnnotations.add(token);
                if (posTags != null) {
                    ((FeatureStructureImpl)token).setStringValue(posFeature, posTags[tokenIndex]);
                }
                if (stems != null) {
                    ((FeatureStructureImpl)token).setStringValue(stemFeature, stems[tokenIndex]);
                }
                ++tokenIndex;
            }
            if (tokenAnnotations.isEmpty()) continue;
            int begin = ((Annotation)tokenAnnotations.get(0)).getBegin();
            int end = ((Annotation)tokenAnnotations.get(tokenAnnotations.size() - 1)).getEnd();
            AnnotationFactory.createAnnotation(aJCas, begin, end, this.sentenceClass);
        }
    }
}

