/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal.propertyeditors;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;

public class GetAsTextStringEditor
extends PropertyEditorSupport {
    private final PropertyEditorRegistry editorRegistry;
    private final PropertyEditorRegistrySupport editorRegistrySupport;

    public GetAsTextStringEditor(PropertyEditorRegistry aEditorRegistry) {
        this.editorRegistry = aEditorRegistry;
        this.editorRegistrySupport = aEditorRegistry instanceof PropertyEditorRegistrySupport ? (PropertyEditorRegistrySupport)aEditorRegistry : new PropertyEditorRegistrySupport();
    }

    public void setValue(Object value) {
        if (value == null || value instanceof String) {
            super.setValue(value);
        } else {
            PropertyEditor editor = this.editorRegistry.findCustomEditor(value.getClass(), null);
            if (editor == null) {
                editor = this.editorRegistrySupport.getDefaultEditor(value.getClass());
            }
            if (editor != null) {
                editor.setValue(value);
                super.setValue(editor.getAsText());
            } else if (Enum.class.isAssignableFrom(value.getClass())) {
                super.setValue(String.valueOf(value));
            } else {
                throw new IllegalArgumentException("Unable to convert " + value.getClass() + " to String. No PropertyEditor found.");
            }
        }
    }

    public void setAsText(String text) {
        this.setValue(text);
    }

    public String getAsText() {
        return (String)this.getValue();
    }
}

