/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.LogFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.impl.TypePriorities_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypePrioritiesFactory {
    private static final Object SCAN_LOCK = new Object();
    private static String[] typePriorityDescriptorLocations;

    private TypePrioritiesFactory() {
    }

    public static TypePriorities createTypePriorities(Class<?> ... prioritizedTypes) {
        String[] typeNames = new String[prioritizedTypes.length];
        for (int i = 0; i < prioritizedTypes.length; ++i) {
            String typeName = prioritizedTypes[i].getName();
            if (typeName.startsWith("org.apache.uima.jcas.")) {
                typeName = "uima." + typeName.substring("org.apache.uima.jcas.".length());
            }
            typeNames[i] = typeName;
        }
        return TypePrioritiesFactory.createTypePriorities(typeNames);
    }

    public static TypePriorities createTypePriorities(String ... prioritizedTypeNames) {
        TypePriorities_impl typePriorities = new TypePriorities_impl();
        TypePriorityList typePriorityList = typePriorities.addPriorityList();
        for (String typeName : prioritizedTypeNames) {
            typePriorityList.addType(typeName);
        }
        return typePriorities;
    }

    public static TypePriorities createTypePriorities() throws ResourceInitializationException {
        ArrayList<TypePriorities> typePrioritiesList = new ArrayList<TypePriorities>();
        for (String location : TypePrioritiesFactory.scanTypePrioritiesDescriptors()) {
            try {
                XMLInputSource xmlInput = new XMLInputSource(location);
                TypePriorities typePriorities = UIMAFramework.getXMLParser().parseTypePriorities(xmlInput);
                typePriorities.resolveImports();
                typePrioritiesList.add(typePriorities);
                LogFactory.getLog(TypePrioritiesFactory.class).debug("Detected type priorities at [" + location + "]");
            }
            catch (IOException e) {
                throw new ResourceInitializationException(e);
            }
            catch (InvalidXMLException e) {
                LogFactory.getLog(TypePrioritiesFactory.class).warn("[" + location + "] is not a type priorities descriptor file. Ignoring.", e);
            }
        }
        ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
        TypePriorities aggTypePriorities = CasCreationUtils.mergeTypePriorities(typePrioritiesList, resMgr);
        return aggTypePriorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanTypePrioritiesDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            if (typePriorityDescriptorLocations == null) {
                typePriorityDescriptorLocations = MetaDataUtil.scanDescriptors(MetaDataType.TYPE_PRIORITIES);
            }
            return typePriorityDescriptorLocations;
        }
    }

    public static void forceTypePrioritiesDescriptorsScan() {
        typePriorityDescriptorLocations = null;
    }
}

