/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;

public class UnambiguousIteratorImpl<T extends AnnotationFS>
extends FSIteratorImplBase<T> {
    private ArrayList<T> list;
    private int pos;
    private Comparator<FeatureStructure> annotationComparator;

    private UnambiguousIteratorImpl() {
        this.pos = 0;
    }

    public UnambiguousIteratorImpl(FSIterator<T> it) {
        this();
        this.list = new ArrayList();
        it.moveToFirst();
        if (!it.isValid()) {
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (current.getEnd() <= next.getBegin()) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    public UnambiguousIteratorImpl(FSIterator<T> it, int start, int end, boolean strict) {
        this.initUnambiguousSubiterator(it, start, end, strict);
    }

    private void initUnambiguousSubiterator(FSIterator<T> it, int start, int end, boolean strict) {
        this.list = new ArrayList();
        it.moveToFirst();
        while (it.isValid() && start > ((AnnotationFS)it.get()).getBegin()) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            this.pos = 0;
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (next.getBegin() < current.getEnd()) {
                it.moveToNext();
                continue;
            }
            if (next.getBegin() > end) break;
            if (!strict || current.getEnd() <= end) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    @Override
    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.list.size();
    }

    @Override
    public T get() throws NoSuchElementException {
        if (this.isValid()) {
            return (T)((AnnotationFS)this.list.get(this.pos));
        }
        throw new NoSuchElementException();
    }

    @Override
    public void moveToNext() {
        ++this.pos;
    }

    @Override
    public void moveToPrevious() {
        --this.pos;
    }

    @Override
    public void moveToFirst() {
        this.pos = 0;
    }

    @Override
    public void moveToLast() {
        this.pos = this.list.size() - 1;
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        int found = Collections.binarySearch(this.list, fs, this.getAnnotationComparator(fs));
        this.pos = found >= 0 ? found : -found - 1;
    }

    private final Comparator<FeatureStructure> getAnnotationComparator(FeatureStructure fs) {
        if (this.annotationComparator == null) {
            this.annotationComparator = new FSIteratorImplBase.AnnotationComparator<FeatureStructure>(fs.getCAS().getAnnotationIndex());
        }
        return this.annotationComparator;
    }

    @Override
    public FSIterator<T> copy() {
        UnambiguousIteratorImpl<T> copy = new UnambiguousIteratorImpl<T>();
        copy.list = this.list;
        copy.pos = this.pos;
        return copy;
    }
}

