/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class ByteArrayFSImpl
extends CommonAuxArrayFSImpl
implements ByteArrayFS {
    public ByteArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new ByteArrayGenerator();
    }

    @Override
    public byte get(int i) {
        this.casImpl.checkArrayBounds(this.addr, i);
        return this.casImpl.ll_getByteArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, byte val) {
        this.casImpl.checkArrayBounds(this.addr, i);
        this.casImpl.ll_setByteArrayValue(this.addr, i, val);
    }

    @Override
    public void copyFromArray(byte[] src, int srcOffset, int destOffset, int length) {
        this.copyFromJavaArray(src, srcOffset, this.casImpl.getByteHeap().heap, destOffset, length);
    }

    @Override
    public void copyToArray(int srcOffset, byte[] dest, int destOffset, int length) {
        this.copyToJavaArray(this.casImpl.getByteHeap().heap, srcOffset, dest, destOffset, length);
    }

    @Override
    public byte[] toArray() {
        return (byte[])this.toArray(this.casImpl.getByteHeap().heap);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        int startOffset = srcOffset + this.casImpl.getHeap().heap[this.casImpl.getArrayStartAddress(this.addr)];
        byte[] heap = this.casImpl.getByteHeap().heap;
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Byte.toString(heap[i + startOffset]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        int startOffset = destOffset + this.casImpl.getHeap().heap[this.casImpl.getArrayStartAddress(this.addr)];
        byte[] heap = this.casImpl.getByteHeap().heap;
        for (int i = 0; i < length; ++i) {
            heap[i + startOffset] = Byte.parseByte(src[i + srcOffset]);
        }
    }

    private static class ByteArrayGenerator
    implements FSGenerator {
        private ByteArrayGenerator() {
        }

        @Override
        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new ByteArrayFSImpl(addr, cas);
        }
    }
}

