/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jsbd.main;

import de.julielab.jcore.types.Sentence;
import de.julielab.jsbd.SentenceSplitter;
import de.julielab.jsbd.Unit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_MODEL_FILE = "ModelFilename";
    public static final String PARAM_DO_POSTPROCESSING = "Postprocessing";
    public static final String PARAM_PROCESSING_SCOPE = "ProcessingScope";
    private static final Logger LOGGER = LoggerFactory.getLogger(SentenceAnnotator.class);
    @ConfigurationParameter(name="Postprocessing", mandatory=false, defaultValue={"false"})
    private boolean doPostprocessing = false;
    @ConfigurationParameter(name="ProcessingScope", mandatory=false)
    private String processingScope;
    @ConfigurationParameter(name="ModelFilename", mandatory=true)
    private String modelFilename;
    private SentenceSplitter sentenceSplitter;
    private Type scopeType;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        Object obj;
        LOGGER.info("[JSBD] initializing...");
        super.initialize(aContext);
        this.sentenceSplitter = new SentenceSplitter();
        try {
            InputStream modelIs;
            LOGGER.info("[JSBD] initializing JSBD Annotator ...");
            this.modelFilename = (String)aContext.getConfigParameterValue(PARAM_MODEL_FILE);
            File modelFile = new File(this.modelFilename);
            if (modelFile.exists()) {
                modelIs = new FileInputStream(modelFile);
            } else {
                LOGGER.debug("File \"{}\" does not exist. Searching for the model as a classpath resource.", (Object)this.modelFilename);
                modelIs = ((Object)((Object)this)).getClass().getResourceAsStream(this.modelFilename.startsWith("/") ? this.modelFilename : "/" + this.modelFilename);
                if (modelIs == null) {
                    throw new IllegalArgumentException("The model file \"" + this.modelFilename + "\" could be found neither in the file system nor in the classpath.");
                }
            }
            this.sentenceSplitter.readModel(modelIs);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        Boolean pp = (Boolean)aContext.getConfigParameterValue(PARAM_DO_POSTPROCESSING);
        if (pp != null) {
            this.doPostprocessing = (Boolean)aContext.getConfigParameterValue(PARAM_DO_POSTPROCESSING);
        }
        if ((obj = aContext.getConfigParameterValue(PARAM_PROCESSING_SCOPE)) != null) {
            this.processingScope = (String)aContext.getConfigParameterValue(PARAM_PROCESSING_SCOPE);
            this.processingScope = this.processingScope.trim();
            if (this.processingScope.length() == 0) {
                this.processingScope = null;
            }
        } else {
            this.processingScope = null;
        }
        LOGGER.info("initialize() - processing scope set to: " + (this.processingScope == null ? "document text" : this.processingScope));
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        if (this.processingScope != null) {
            try {
                if (this.scopeType == null) {
                    this.scopeType = aJCas.getTypeSystem().getType(this.processingScope);
                    if (this.scopeType == null) {
                        throw new AnalysisEngineProcessException((Throwable)new IllegalArgumentException("The processing scope type " + this.processingScope + " for parameter " + PARAM_PROCESSING_SCOPE + " was not found in the type system."));
                    }
                }
                for (Annotation annotation : aJCas.getAnnotationIndex(this.scopeType)) {
                    String annoText = annotation.getCoveredText();
                    if (annoText == null || annoText.length() <= 0) continue;
                    this.doSegmentation(aJCas, annoText);
                }
            }
            catch (Exception e) {
                LOGGER.error("process() - could not create Annotation object for the ProcessingScope.");
                throw new AnalysisEngineProcessException();
            }
        } else if (aJCas.getDocumentText() != null && aJCas.getDocumentText().length() > 0) {
            this.doSegmentation(aJCas, aJCas.getDocumentText());
        } else {
            LOGGER.warn("process() - document text empty. Skipping this document.");
        }
    }

    private void doSegmentation(JCas aJCas, String text) throws AnalysisEngineProcessException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(text);
        ArrayList<Unit> units = this.sentenceSplitter.predict(lines, this.doPostprocessing);
        this.addAnnotations(aJCas, units);
    }

    private void addAnnotations(JCas aJCas, ArrayList<Unit> units) {
        int start = 0;
        int i = 0;
        while (i < units.size()) {
            Unit myUnit = units.get(i);
            String decision = units.get((int)i).label;
            if (start == -1) {
                start = myUnit.begin;
            }
            if (decision.equals("EOS") || i == units.size() - 1) {
                Sentence annotation = new Sentence(aJCas);
                annotation.setBegin(start);
                annotation.setEnd(myUnit.end);
                annotation.setComponentId(((Object)((Object)this)).getClass().getName());
                annotation.addToIndexes();
                start = -1;
            }
            ++i;
        }
    }
}

