/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.jcore.utility.JCoReFSListIterator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReAnnotationIndexMerger {
    boolean firstToken;
    private JCas aJCas;
    private LinkedHashSet<Type> annotationTypes = new LinkedHashSet();
    private List<FSIterator<? extends TOP>> annotationIterators;
    private boolean beginOffsetHasChanged;
    private TOP currentAnnotation;
    private int currentBegin;
    private int currentEnd;
    private int currentIndex;
    private int oldBeginOffset;
    private boolean sort;
    private AnnotationFS coveringAnnotation;

    public JCoReAnnotationIndexMerger(Set<?> annotationTypes, boolean sort, AnnotationFS coveringAnnotation, JCas aJCas) throws ClassNotFoundException {
        annotationTypes.forEach(i -> {
            if (i instanceof Integer) {
                this.annotationTypes.add(aJCas.getCasType((Integer)i));
            } else if (i instanceof String) {
                Type type = aJCas.getTypeSystem().getType((String)i);
                if (type == null) {
                    throw new IllegalArgumentException("The type \"" + i + "\" was not found in the type system.");
                }
                this.annotationTypes.add(type);
            } else if (i instanceof Type) {
                this.annotationTypes.add((Type)i);
            } else {
                throw new IllegalArgumentException("For the specification of annotation types to merge, the CAS integer constant, the fully qualified type name or the Type instance is required. The given objects are of class " + i.getClass().getCanonicalName());
            }
        });
        this.sort = sort;
        this.coveringAnnotation = coveringAnnotation;
        this.aJCas = aJCas;
        this.reset();
    }

    public boolean firstToken() {
        return this.firstToken;
    }

    public TOP getAnnotation() {
        return this.currentAnnotation;
    }

    public int getCurrentBegin() {
        return this.currentBegin;
    }

    public void setCurrentBegin(int currentBegin) {
        this.currentBegin = currentBegin;
    }

    public int getCurrentEnd() {
        return this.currentEnd;
    }

    public void setCurrentEnd(int currentEnd) {
        this.currentEnd = currentEnd;
    }

    public boolean hasBeginOffsetChanged() {
        return this.beginOffsetHasChanged;
    }

    public boolean incrementAnnotation() {
        if (this.currentIndex == -1) {
            return this.moveIterator(true);
        }
        return this.moveIterator(false);
    }

    protected boolean moveIterator(boolean initialize) {
        int minBegin = Integer.MAX_VALUE;
        if (!initialize) {
            this.annotationIterators.get(this.currentIndex).moveToNext();
            this.firstToken = false;
            if (!this.sort && this.annotationIterators.get(this.currentIndex).isValid()) {
                this.setCurrentAnnotation();
                return true;
            }
        }
        for (int i = 0; i < this.annotationIterators.size(); ++i) {
            int itBegin;
            FSIterator<? extends TOP> it = this.annotationIterators.get(i);
            if (initialize) {
                it.moveToFirst();
            }
            if (!it.isValid()) continue;
            int n = itBegin = it.get() instanceof Annotation ? ((Annotation)it.get()).getBegin() : 0;
            if (itBegin >= minBegin) continue;
            minBegin = itBegin;
            this.currentIndex = i;
        }
        if (this.currentIndex != -1 && this.annotationIterators.get(this.currentIndex).isValid()) {
            this.setCurrentAnnotation();
            this.beginOffsetHasChanged = this.currentBegin != this.oldBeginOffset;
            this.oldBeginOffset = this.currentBegin;
            return true;
        }
        this.currentAnnotation = null;
        return false;
    }

    private void reset() throws ClassNotFoundException {
        this.annotationIterators = new ArrayList<FSIterator<? extends TOP>>(this.annotationTypes.size());
        for (Type type : this.annotationTypes) {
            if (this.aJCas.getTypeSystem().subsumes(this.aJCas.getCasType(Annotation.type), type)) {
                if (null == this.coveringAnnotation) {
                    this.annotationIterators.add(this.aJCas.getAnnotationIndex(type).iterator());
                    continue;
                }
                Type casType = type;
                Class<?> annotationClass = Class.forName(casType.getName());
                List<?> coveredAnnotations = JCoReAnnotationTools.getIncludedAnnotations(this.aJCas, (Annotation)this.coveringAnnotation, annotationClass);
                JCoReFSListIterator fsit = new JCoReFSListIterator(coveredAnnotations);
                this.annotationIterators.add(fsit);
                continue;
            }
            this.annotationIterators.add(this.aJCas.getJFSIndexRepository().getAllIndexedFS(type));
        }
        this.beginOffsetHasChanged = true;
        this.oldBeginOffset = -1;
        this.currentIndex = -1;
        this.firstToken = true;
    }

    protected void setCurrentAnnotation() {
        this.currentAnnotation = this.annotationIterators.get(this.currentIndex).get();
        if (this.currentAnnotation instanceof Annotation) {
            Annotation a = (Annotation)this.currentAnnotation;
            this.currentBegin = a.getBegin();
            this.currentEnd = a.getEnd();
        } else {
            this.currentBegin = 0;
            this.currentEnd = 0;
        }
    }
}

