/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTraceEvent_impl;

public class ProcessTrace_impl
implements ProcessTrace {
    private static final long serialVersionUID = 7566277176545062757L;
    private List<ProcessTraceEvent> mEventList = new ArrayList<ProcessTraceEvent>();
    private Stack<ProcessTraceEvent_impl> mOpenEvents = new Stack();
    private UimaTimer mTimer;
    private boolean mEnabled;

    public ProcessTrace_impl() {
        this(UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public ProcessTrace_impl(Properties aPerformanceTuningSettings) {
        if (aPerformanceTuningSettings == null) {
            aPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();
        }
        this.mEnabled = "true".equalsIgnoreCase(aPerformanceTuningSettings.getProperty("process_trace_enabled"));
        if (this.mEnabled) {
            this.mTimer = UIMAFramework.newTimer();
        }
    }

    public ProcessTrace_impl(UimaTimer aTimer) {
        this(aTimer, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public ProcessTrace_impl(UimaTimer aTimer, Properties aPerformanceTuningSettings) {
        this.mTimer = aTimer;
        if (aPerformanceTuningSettings == null) {
            aPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();
        }
        this.mEnabled = "true".equalsIgnoreCase(aPerformanceTuningSettings.getProperty("process_trace_enabled"));
    }

    @Override
    public void startEvent(String aComponentName, String aEventType, String aDescription) {
        if (this.mEnabled) {
            ProcessTraceEvent_impl evt = new ProcessTraceEvent_impl(aComponentName, aEventType, aDescription);
            evt.setStartTime(this.mTimer.getTimeInMillis());
            this.mOpenEvents.push(evt);
        }
    }

    @Override
    public void endEvent(String aComponentName, String aEventType, String aResultMessage) {
        if (this.mEnabled) {
            ArrayList<ProcessTraceEvent_impl> eventsToClose = new ArrayList<ProcessTraceEvent_impl>();
            boolean foundEvent = false;
            while (!this.mOpenEvents.isEmpty()) {
                ProcessTraceEvent_impl evt = this.mOpenEvents.pop();
                eventsToClose.add(evt);
                if (!aComponentName.equals(evt.getComponentName()) || !aEventType.equals(evt.getType())) continue;
                foundEvent = true;
                break;
            }
            if (foundEvent) {
                long currentTime = this.mTimer.getTimeInMillis();
                for (int i = 0; i < eventsToClose.size(); ++i) {
                    ProcessTraceEvent_impl subEvt = (ProcessTraceEvent_impl)eventsToClose.get(i);
                    subEvt.setResultMessage(aResultMessage);
                    subEvt.setDuration((int)(currentTime - subEvt.getStartTime()));
                    ProcessTraceEvent_impl owner = null;
                    if (i < eventsToClose.size() - 1) {
                        owner = (ProcessTraceEvent_impl)eventsToClose.get(i + 1);
                    } else if (!this.mOpenEvents.isEmpty()) {
                        owner = this.mOpenEvents.peek();
                    }
                    if (owner != null) {
                        owner.addSubEvent(subEvt);
                        continue;
                    }
                    this.mEventList.add(subEvt);
                }
            } else {
                for (int i = 0; i < eventsToClose.size(); ++i) {
                    this.mOpenEvents.push((ProcessTraceEvent_impl)eventsToClose.get(i));
                }
                throw new UIMA_IllegalStateException("required_method_call", new Object[]{"startEvent", "endEvent"});
            }
        }
    }

    @Override
    public void addEvent(String aComponentName, String aType, String aDescription, int aDuration, String aResultMsg) {
        if (this.mEnabled) {
            ProcessTraceEvent_impl evt = new ProcessTraceEvent_impl(aComponentName, aType, aDescription);
            evt.setDuration(aDuration);
            evt.setResultMessage(aResultMsg);
            this.addEvent(evt);
        }
    }

    @Override
    public void addEvent(ProcessTraceEvent aEvent) {
        if (this.mEnabled) {
            if (!this.mOpenEvents.isEmpty()) {
                ProcessTraceEvent_impl owner = this.mOpenEvents.peek();
                owner.addSubEvent(aEvent);
            } else {
                this.mEventList.add(aEvent);
            }
        }
    }

    @Override
    public void addAll(List<ProcessTraceEvent> aEventList) {
        for (ProcessTraceEvent evt : aEventList) {
            this.addEvent(evt);
        }
    }

    @Override
    public List<ProcessTraceEvent> getEvents() {
        return this.mEventList;
    }

    @Override
    public List<ProcessTraceEvent> getEventsByComponentName(String aComponentName, boolean aRecurseAfterMatch) {
        ArrayList<ProcessTraceEvent> result = new ArrayList<ProcessTraceEvent>();
        for (ProcessTraceEvent event : this.getEvents()) {
            this.getEventsByComponentName(event, aComponentName, aRecurseAfterMatch, result);
        }
        return result;
    }

    @Override
    public List<ProcessTraceEvent> getEventsByType(String aType, boolean aRecurseAfterMatch) {
        ArrayList<ProcessTraceEvent> result = new ArrayList<ProcessTraceEvent>();
        for (ProcessTraceEvent event : this.getEvents()) {
            this.getEventsByType(event, aType, aRecurseAfterMatch, result);
        }
        return result;
    }

    @Override
    public ProcessTraceEvent getEvent(String aComponentName, String aType) {
        List<ProcessTraceEvent> events = this.getEvents();
        return this.getEvent(events, aComponentName, aType);
    }

    protected ProcessTraceEvent getEvent(List<ProcessTraceEvent> aEvents, String aComponentName, String aType) {
        for (ProcessTraceEvent event : aEvents) {
            if (aComponentName.equals(event.getComponentName()) && aType.equals(event.getType())) {
                return event;
            }
            ProcessTraceEvent matchingSubEvt = this.getEvent(event.getSubEvents(), aComponentName, aType);
            if (matchingSubEvt == null) continue;
            return matchingSubEvt;
        }
        return null;
    }

    @Override
    public void clear() {
        this.mEventList.clear();
    }

    @Override
    public void aggregate(ProcessTrace aProcessTrace) {
        if (this.mEnabled) {
            List<ProcessTraceEvent> newEventList = aProcessTrace.getEvents();
            for (ProcessTraceEvent_impl processTraceEvent_impl : newEventList) {
                ProcessTraceEvent_impl correspondingEvt = this.findCorrespondingEvent(this.mEventList, processTraceEvent_impl);
                if (correspondingEvt != null) {
                    this.aggregateEvent(correspondingEvt, processTraceEvent_impl);
                    continue;
                }
                this.mEventList.add(processTraceEvent_impl);
            }
        }
    }

    @Override
    public String toString() {
        int totalTime = 0;
        for (ProcessTraceEvent event : this.mEventList) {
            totalTime += event.getDuration();
        }
        StringBuffer buf = new StringBuffer();
        for (ProcessTraceEvent event : this.mEventList) {
            event.toString(buf, 0, totalTime);
        }
        return buf.toString();
    }

    protected void getEventsByComponentName(ProcessTraceEvent aEvent, String aComponentName, boolean aRecurseAfterMatch, List<ProcessTraceEvent> aResultList) {
        if (aComponentName.equals(aEvent.getComponentName())) {
            aResultList.add(aEvent);
            if (!aRecurseAfterMatch) {
                return;
            }
        }
        for (ProcessTraceEvent event : aEvent.getSubEvents()) {
            this.getEventsByComponentName(event, aComponentName, aRecurseAfterMatch, aResultList);
        }
    }

    protected void getEventsByType(ProcessTraceEvent aEvent, String aType, boolean aRecurseAfterMatch, List<ProcessTraceEvent> aResultList) {
        if (aType.equals(aEvent.getType())) {
            aResultList.add(aEvent);
            if (!aRecurseAfterMatch) {
                return;
            }
        }
        for (ProcessTraceEvent event : aEvent.getSubEvents()) {
            this.getEventsByType(event, aType, aRecurseAfterMatch, aResultList);
        }
    }

    protected <T extends ProcessTraceEvent> T findCorrespondingEvent(List<T> aEventList, T aEvent) {
        for (ProcessTraceEvent evt : aEventList) {
            if (!evt.getComponentName().equals(aEvent.getComponentName()) || !evt.getType().equals(aEvent.getType())) continue;
            return (T)evt;
        }
        return null;
    }

    protected void aggregateEvent(ProcessTraceEvent_impl aDest, ProcessTraceEvent_impl aSrc) {
        aDest.addToDuration(aSrc.getDuration());
        aDest.setResultMessage(aSrc.getResultMessage());
        List<ProcessTraceEvent> destEventList = aDest.getSubEvents();
        List<ProcessTraceEvent> srcEventList = aSrc.getSubEvents();
        ArrayList<ProcessTraceEvent_impl> eventsToAdd = null;
        for (ProcessTraceEvent_impl processTraceEvent_impl : srcEventList) {
            ProcessTraceEvent_impl processTraceEvent_impl2 = this.findCorrespondingEvent(destEventList, processTraceEvent_impl);
            if (processTraceEvent_impl2 != null) {
                this.aggregateEvent(processTraceEvent_impl2, processTraceEvent_impl);
                continue;
            }
            if (eventsToAdd == null) {
                eventsToAdd = new ArrayList<ProcessTraceEvent_impl>();
            }
            eventsToAdd.add(processTraceEvent_impl);
        }
        if (eventsToAdd != null) {
            for (ProcessTraceEvent processTraceEvent : eventsToAdd) {
                aDest.addSubEvent(processTraceEvent);
            }
        }
    }
}

