/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.InputStream;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;

public class SofaFSImpl
extends FeatureStructureImplC
implements SofaFS {
    static FSGenerator getSofaFSGenerator() {
        return new SofaFSGenerator();
    }

    public SofaFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    @Override
    public void setLocalSofaData(FeatureStructure aFS) {
        Feature arrayFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaArray");
        if (this.isSofaDataSet()) {
            CASRuntimeException e = new CASRuntimeException("SOFADATA_ALREADY_SET", new String[]{"SetLocalSofaData(FeatureStructure)"});
            throw e;
        }
        Type type = aFS.getType();
        if (!type.isArray()) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_TYPE", new String[]{"Array FS", type.getName()});
            throw e;
        }
        if (!(type.getName().equals("uima.cas.ByteArray") || type.getName().equals("uima.cas.DoubleArray") || type.getName().equals("uima.cas.FloatArray") || type.getName().equals("uima.cas.IntegerArray") || type.getName().equals("uima.cas.LongArray") || type.getName().equals("uima.cas.ShortArray") || type.getName().equals("uima.cas.StringArray"))) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_TYPE", new String[]{"Byte/Float/Integer/Short/String/Long/Double Array", type.getName()});
            throw e;
        }
        super.setFeatureValue(arrayFeat, aFS);
    }

    @Override
    public void setLocalSofaData(String aString) {
        Feature stringFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaString");
        if (this.isSofaDataSet()) {
            CASRuntimeException e = new CASRuntimeException("SOFADATA_ALREADY_SET", new String[]{"setLocalSofaData(String)"});
            throw e;
        }
        super.setStringValue(stringFeat, aString);
        CAS view = this.casImpl.getView(this);
        ((CASImpl)view).updateDocumentAnnotation();
    }

    @Override
    public void setRemoteSofaURI(String aURI) {
        Feature uriFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaURI");
        if (this.isSofaDataSet()) {
            CASRuntimeException e = new CASRuntimeException("SOFADATA_ALREADY_SET", new String[]{"setRemoteSofaURI(String)"});
            throw e;
        }
        super.setStringValue(uriFeat, aURI);
    }

    private boolean isSofaDataSet() {
        Feature uriFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaURI");
        Feature arrayFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaArray");
        Feature stringFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaString");
        return null != this.getStringValue(uriFeat) || null != this.getFeatureValue(arrayFeat) || null != this.getStringValue(stringFeat);
    }

    @Override
    public FeatureStructure getLocalFSData() {
        Feature arrayFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaArray");
        return this.getFeatureValue(arrayFeat);
    }

    @Override
    public String getLocalStringData() {
        Feature stringFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaString");
        return this.getStringValue(stringFeat);
    }

    @Override
    public void setStringValue(Feature feat, String val) {
        CASRuntimeException e = new CASRuntimeException("PROTECTED_SOFA_FEATURE");
        throw e;
    }

    @Override
    public void setFeatureValue(Feature feat, FeatureStructure fs) {
        CASRuntimeException e = new CASRuntimeException("PROTECTED_SOFA_FEATURE");
        throw e;
    }

    public void setIntValue(Feature feat, Integer val) {
        CASRuntimeException e = new CASRuntimeException("PROTECTED_SOFA_FEATURE");
        throw e;
    }

    @Override
    public String getSofaMime() {
        Feature mimeFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:mimeType");
        return this.casImpl.getLowLevelCAS().ll_getStringValue(this.addr, ((FeatureImpl)mimeFeat).getCode());
    }

    @Override
    public String getSofaURI() {
        Feature uriFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaURI");
        return this.casImpl.getLowLevelCAS().ll_getStringValue(this.addr, ((FeatureImpl)uriFeat).getCode());
    }

    @Override
    public int getSofaRef() {
        Feature numFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaNum");
        return this.casImpl.getLowLevelCAS().ll_getIntValue(this.addr, ((FeatureImpl)numFeat).getCode());
    }

    @Override
    public InputStream getSofaDataStream() {
        return this.casImpl.getSofaDataStream(this);
    }

    @Override
    public String getSofaID() {
        Feature sofaIDFeat = this.casImpl.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
        return this.getStringValue(sofaIDFeat);
    }

    private static class SofaFSGenerator
    implements FSGenerator {
        private SofaFSGenerator() {
        }

        @Override
        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new SofaFSImpl(addr, cas);
        }
    }
}

