/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class ShortArrayFSImpl
extends CommonAuxArrayFSImpl
implements ShortArrayFS {
    public ShortArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new ShortArrayGenerator();
    }

    @Override
    public short get(int i) {
        this.casImpl.checkArrayBounds(this.addr, i);
        return this.casImpl.ll_getShortArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, short val) {
        this.casImpl.checkArrayBounds(this.addr, i);
        this.casImpl.ll_setShortArrayValue(this.addr, i, val);
    }

    @Override
    public void copyFromArray(short[] src, int srcOffset, int destOffset, int length) {
        this.copyFromJavaArray(src, srcOffset, this.casImpl.getShortHeap().heap, destOffset, length);
    }

    @Override
    public void copyToArray(int srcOffset, short[] dest, int destOffset, int length) {
        this.copyToJavaArray(this.casImpl.getShortHeap().heap, srcOffset, dest, destOffset, length);
    }

    @Override
    public short[] toArray() {
        return (short[])this.toArray(this.casImpl.getShortHeap().heap);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        srcOffset += this.casImpl.getHeap().heap[this.casImpl.getArrayStartAddress(this.addr)];
        short[] heap = this.casImpl.getShortHeap().heap;
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Short.toString(heap[i + srcOffset]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) throws ArrayIndexOutOfBoundsException {
        short[] bArray = new short[length];
        for (int i = 0; i < length; ++i) {
            bArray[i] = Short.parseShort(src[i]);
        }
        this.copyFromArray(bArray, srcOffset, destOffset, length);
    }

    private static class ShortArrayGenerator
    implements FSGenerator {
        private ShortArrayGenerator() {
        }

        @Override
        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new ShortArrayFSImpl(addr, cas);
        }
    }
}

