/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelIteratorWrapper;
import org.apache.uima.internal.util.ComparableIntIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.rb_trees.CompIntArrayRBT;

class FSRBTSetIndex<T extends FeatureStructure>
extends FSLeafIndexImpl<T> {
    private CompIntArrayRBT tree = null;

    public FSRBTSetIndex(CASImpl cas, Type type, int indexType) {
        super(cas, type, indexType);
    }

    @Override
    boolean init(FSIndexComparator comp) {
        boolean rc = super.init(comp);
        this.tree = new CompIntArrayRBT(this);
        return rc;
    }

    @Override
    public void flush() {
        this.tree.flush();
    }

    @Override
    boolean insert(int fs) {
        this.tree.insertKey(fs);
        return true;
    }

    @Override
    public FeatureStructure find(FeatureStructure fs) {
        LowLevelCAS llc = fs.getCAS().getLowLevelCAS();
        int addr = llc.ll_getFSRef(fs);
        int resultAddr = this.tree.getKeyForNode(this.tree.findKey(addr));
        if (resultAddr > 0) {
            return llc.ll_getFSForRef(resultAddr);
        }
        return null;
    }

    @Override
    public IntPointerIterator refIterator() {
        return this.tree.pointerIterator();
    }

    ComparableIntIterator refIterator(IntComparator comp) {
        return this.tree.iterator(comp);
    }

    @Override
    public ComparableIntPointerIterator pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        return this.tree.pointerIterator(comp, detectIllegalIndexUpdates, typeCode);
    }

    @Override
    protected IntPointerIterator refIterator(int fsCode) {
        return this.tree.pointerIterator(fsCode);
    }

    @Override
    public boolean contains(FeatureStructure fs) {
        return this.tree.containsKey(((FeatureStructureImpl)fs).getAddress());
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void deleteFS(FeatureStructure fs) {
        int addr = ((FeatureStructureImpl)fs).getAddress();
        this.tree.deleteKey(addr);
    }

    @Override
    public LowLevelIterator ll_iterator() {
        return new LowLevelIteratorWrapper(this.tree.pointerIterator(), this);
    }

    @Override
    void remove(int fs) {
        this.tree.deleteKey(fs);
    }
}

