/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import org.apache.uima.cas.impl.CommonAuxHeap;

final class ByteHeap
extends CommonAuxHeap {
    byte[] heap;

    ByteHeap() {
        super(16, 524288);
    }

    ByteHeap(int heapBaseSize, int heapMultLimit) {
        super(heapBaseSize, heapMultLimit);
    }

    @Override
    final void initMemory() {
        this.heap = new byte[this.heapBaseSize];
    }

    @Override
    void growHeapIfNeeded() {
        if (this.heap.length >= this.heapPos) {
            return;
        }
        byte[] new_array = new byte[this.computeNewArraySize(this.heap.length, this.heapPos, 2, this.heapMultLimit)];
        System.arraycopy(this.heap, 0, new_array, 0, this.heap.length);
        this.heap = new_array;
    }

    @Override
    void resetToZeros() {
        Arrays.fill(this.heap, 0, this.heapPos, (byte)0);
    }

    byte getHeapValue(int offset) {
        return this.heap[offset];
    }

    void setHeapValue(byte val, int pos) {
        this.heap[pos] = val;
    }

    int addByte(byte val) {
        int pos = this.reserve(1);
        this.heap[pos] = val;
        return pos;
    }

    protected void reinit(byte[] byteHeap) {
        int argLength = byteHeap.length;
        if (argLength > this.heap.length) {
            this.heap = new byte[argLength];
        }
        System.arraycopy(byteHeap, 0, this.heap, 0, argLength);
        this.heapPos = argLength;
    }
}

