/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility.index;

import de.julielab.jcore.utility.index.JCoReAnnotationIndex;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReSetAnnotationIndex<E extends Annotation>
implements JCoReAnnotationIndex<E> {
    private TreeSet<E> index;

    public JCoReSetAnnotationIndex(Comparator<? super E> comparator, JCas jCas, Type type) {
        this.index = new TreeSet<E>(comparator);
        if (jCas != null && type != null) {
            this.index(jCas, type);
        }
    }

    public JCoReSetAnnotationIndex(Comparator<? super E> comparator, JCas jCas, int type) {
        this(comparator, jCas, jCas.getCasType(type));
    }

    public JCoReSetAnnotationIndex(Comparator<? super E> comparator) {
        this(comparator, null, null);
    }

    @Override
    public void index(JCas jCas, int type) {
        this.index(jCas, jCas.getCasType(type));
    }

    @Override
    public void index(JCas jCas, Type type) {
        for (Annotation annotation : jCas.getAnnotationIndex(type)) {
            this.index((E)annotation);
        }
    }

    @Override
    public void index(E annotation) {
        this.index.add(annotation);
    }

    @Override
    public void add(E annotation) {
        this.index(annotation);
    }

    public Stream<E> search(E a) {
        return this.searchSubset(a).stream();
    }

    public NavigableSet<E> searchSubset(E a) {
        Annotation higher;
        if (this.index.isEmpty()) {
            return Collections.emptyNavigableSet();
        }
        boolean firstInclusive = false;
        boolean lastInclusive = false;
        Annotation lower = (Annotation)this.index.lower(a);
        if (lower == null) {
            lower = (Annotation)this.index.first();
            firstInclusive = true;
        }
        if ((higher = (Annotation)this.index.higher(a)) == null) {
            higher = (Annotation)this.index.last();
            lastInclusive = true;
        }
        return this.index.subSet(lower, firstInclusive, higher, lastInclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(E a) {
        Annotation result = null;
        try {
            Annotation annotation = result = (Annotation)this.index.floor(a);
            return (E)annotation;
        }
        finally {
            Annotation ceiling = (Annotation)this.index.ceiling(a);
            if (ceiling != null && this.index.comparator().compare(result, ceiling) != 0) {
                throw new IllegalStateException("There are multiple index items matching " + a + ". Use the search(E) method.");
            }
        }
    }

    public boolean contains(Annotation a) {
        return this.index.contains(a);
    }

    public Stream<E> items() {
        return this.index.stream();
    }

    public TreeSet<E> getIndex() {
        return this.index;
    }
}

