/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.Label;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Labels;
import cc.mallet.types.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LabelsSequence
implements Sequence,
AlphabetCarrying,
Serializable {
    Labels[] seq;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public LabelsSequence(Labels[] seq) {
        int i = 0;
        while (i < seq.length - 1) {
            if (!Alphabet.alphabetsMatch(seq[i], seq[i + 1])) {
                throw new IllegalArgumentException("Alphabets do not match");
            }
            ++i;
        }
        this.seq = new Labels[seq.length];
        System.arraycopy(seq, 0, this.seq, 0, seq.length);
    }

    public LabelsSequence(LabelSequence seq) {
        this.seq = new Labels[seq.size()];
        int i = 0;
        while (i < seq.length) {
            this.seq[i] = new Labels(new Label[]{seq.getLabelAtPosition(i)});
            ++i;
        }
    }

    @Override
    public Alphabet getAlphabet() {
        return this.seq[0].getAlphabet();
    }

    @Override
    public Alphabet[] getAlphabets() {
        return this.seq[0].getAlphabets();
    }

    @Override
    public int size() {
        return this.seq.length;
    }

    public Object get(int i) {
        return this.seq[i];
    }

    public Labels getLabels(int i) {
        return this.seq[i];
    }

    public String toString() {
        String ret = "LabelsSequence:\n";
        int i = 0;
        while (i < this.seq.length) {
            ret = String.valueOf(ret) + i + ": ";
            ret = String.valueOf(ret) + this.seq[i].toString();
            ret = String.valueOf(ret) + "\n";
            ++i;
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        in.defaultReadObject();
    }
}

