/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.examples;

import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.LabelsAssignment;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;

public class CrossTemplate1
extends ACRF.SequenceTemplate {
    private int lvl1 = 0;
    private int lvl2 = 1;

    public CrossTemplate1(int lvl1, int lvl2) {
        this.lvl1 = lvl1;
        this.lvl2 = lvl2;
    }

    @Override
    protected void addInstantiatedCliques(ACRF.UnrolledGraph graph, FeatureVectorSequence fvs, LabelsAssignment lblseq) {
        int t = 0;
        while (t < lblseq.size() - 1) {
            Variable var1 = lblseq.varOfIndex(t, this.lvl1);
            Variable var2 = lblseq.varOfIndex(t + 1, this.lvl2);
            assert (var1 != null) : "Couldn't get label factor " + this.lvl1 + " time " + t;
            assert (var2 != null) : "Couldn't get label factor " + this.lvl2 + " time " + (t + 1);
            Variable[] vars = new Variable[]{var1, var2};
            FeatureVector fv = fvs.getFeatureVector(t);
            ACRF.UnrolledVarSet vs = new ACRF.UnrolledVarSet(graph, this, vars, fv);
            graph.addClique(vs);
            ++t;
        }
    }
}

