/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jpos.pipes;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import com.uea.stemmer.UEALite;
import de.julielab.jcore.ae.jpos.tagger.FeatureConfiguration;
import de.julielab.jcore.ae.jpos.tagger.Sentence;
import de.julielab.jcore.ae.jpos.tagger.Unit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tartarus.snowball.SnowballProgram;

class BasePipe
extends Pipe {
    private static final String UNICODE_LOWER = "\\p{Ll}";
    private static final String UNICODE_UPPER = "\\p{Lu}";
    private static final long serialVersionUID = 24L;
    static Logger LOGGER = LoggerFactory.getLogger(BasePipe.class);
    Properties featureConfig;
    boolean pluralFeature = false;
    boolean lowerCaseFeature = false;
    boolean wcFeature = false;
    boolean bwcFeature = false;
    String[] customPluralSuffixes;
    Pattern UpperCaseStart;
    String snowballStemmerLanguage;
    Object stemmer;
    transient Stemmer wrappedStemmer;
    private final String[] snowballLanguage;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.stemmer instanceof UEALite) {
            this.wrappedStemmer = new Stemmer((UEALite)this.stemmer);
            LOGGER.debug("Got UEALite stemmer in loaded model: {}", (Object)this.wrappedStemmer);
        } else if (null != this.snowballLanguage) {
            this.wrappedStemmer = new Stemmer(this.snowballStemmerLanguage);
            LOGGER.debug("Got snowball stemmer for language {} in loaded model", (Object)this.snowballStemmerLanguage);
        } else {
            throw new IllegalStateException("No stemmer was found in the stored model, this is invalid.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BasePipe(Properties featureConfig) {
        super(new Alphabet(), (Alphabet)new LabelAlphabet());
        this.featureConfig = featureConfig;
        this.UpperCaseStart = Pattern.compile("[\\p{Lu}][^\\p{Lu}]*");
        FeatureConfiguration fc = new FeatureConfiguration();
        if (fc.featureActive(featureConfig, "feat_lowercase_enabled")) {
            this.lowerCaseFeature = true;
        }
        if (fc.featureActive(featureConfig, "feat_plural_enabled")) {
            this.pluralFeature = true;
        }
        if (this.pluralFeature) {
            this.customPluralSuffixes = fc.getStringArray(featureConfig, "customPluralSuffixes");
        }
        if (fc.featureActive(featureConfig, "feat_wc_enabled")) {
            this.wcFeature = true;
        }
        if (fc.featureActive(featureConfig, "feat_bwc_enabled")) {
            this.bwcFeature = true;
        }
        this.snowballLanguage = fc.getStringArray(featureConfig, "SnowballStemmerLanguage");
        if (this.snowballLanguage != null) {
            if (this.snowballLanguage.length != 1) throw new IllegalArgumentException("Choose 1 language!");
            this.wrappedStemmer = new Stemmer(this.snowballLanguage[0]);
            this.snowballStemmerLanguage = this.snowballLanguage[0];
            return;
        } else {
            this.wrappedStemmer = new Stemmer(new UEALite());
            this.stemmer = this.wrappedStemmer.UEAstemmer;
        }
    }

    public Instance pipe(Instance carrier) {
        int i;
        Sentence sentence = (Sentence)carrier.getData();
        ArrayList<Unit> sentenceUnits = sentence.getUnits();
        StringBuffer source = new StringBuffer();
        TokenSequence data = new TokenSequence(sentenceUnits.size());
        LabelSequence target = new LabelSequence((LabelAlphabet)this.getTargetAlphabet(), sentenceUnits.size());
        String[] stemmedWords = new String[sentenceUnits.size()];
        String[] unstemmedWords = new String[sentenceUnits.size()];
        for (i = 0; i < sentenceUnits.size(); ++i) {
            String[] m;
            String myWord = sentenceUnits.get(i).getRep();
            if (this.lowerCaseFeature && (m = this.UpperCaseStart.matcher(myWord)).matches()) {
                myWord = myWord.toLowerCase();
            }
            unstemmedWords[i] = myWord;
            stemmedWords[i] = this.wrappedStemmer.stem(unstemmedWords[i]);
        }
        try {
            for (i = 0; i < sentenceUnits.size(); ++i) {
                Token token;
                String currWord;
                block10: {
                    block11: {
                        currWord = stemmedWords[i];
                        token = new Token(currWord);
                        token.setFeatureValue("W=" + currWord, 1.0);
                        if (!this.pluralFeature) break block10;
                        if (this.customPluralSuffixes != null) break block11;
                        if (!unstemmedWords[i].equals(stemmedWords[i] + "s")) break block10;
                        token.setFeatureValue("PLURAL", 1.0);
                        break block10;
                    }
                    for (String suffix : this.customPluralSuffixes) {
                        if (!unstemmedWords[i].equals(stemmedWords[i] + suffix)) continue;
                        token.setFeatureValue("PLURAL", 1.0);
                        break;
                    }
                }
                token.setText(currWord);
                if (this.wcFeature) {
                    String wc = currWord;
                    wc = wc.replaceAll(UNICODE_UPPER, "A");
                    wc = wc.replaceAll(UNICODE_LOWER, "a");
                    wc = wc.replaceAll("[0-9]", "0");
                    wc = wc.replaceAll("[^\\p{Lu}\\p{Ll}0-9]", "x");
                    token.setFeatureValue("WC=" + wc, 1.0);
                }
                if (this.bwcFeature) {
                    String bwc = currWord;
                    bwc = bwc.replaceAll("\\p{Lu}+", "A");
                    bwc = bwc.replaceAll("\\p{Ll}+", "a");
                    bwc = bwc.replaceAll("[0-9]+", "0");
                    bwc = bwc.replaceAll("[^\\p{Lu}\\p{Ll}0-9]+", "x");
                    token.setFeatureValue("BWC=" + bwc, 1.0);
                }
                source.append(token.getText());
                source.append(" ");
                data.add((Object)token);
                try {
                    target.add((Object)sentenceUnits.get(i).getLabel());
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Could not process: " + carrier.getData());
                    throw e;
                }
            }
            carrier.setData((Object)data);
            carrier.setTarget((Object)target);
            carrier.setSource((Object)source);
            return carrier;
        }
        catch (Exception e) {
            RuntimeException e1 = new RuntimeException(e);
            e.printStackTrace();
            LOGGER.error("", (Throwable)e1);
            throw e1;
        }
    }

    private class Stemmer
    implements Serializable {
        private static final long serialVersionUID = 666999L;
        private UEALite UEAstemmer = null;
        private SnowballProgram snowStemmer = null;

        Stemmer(UEALite stemmer) {
            this.UEAstemmer = stemmer;
        }

        Stemmer(String lang) {
            try {
                Class<?> stemClass = Class.forName("org.tartarus.snowball.ext." + lang + "Stemmer");
                this.snowStemmer = (SnowballProgram)stemClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        String stem(String word) {
            if (this.UEAstemmer != null) {
                return this.UEAstemmer.stem(word).getWord();
            }
            if (this.snowStemmer != null) {
                this.snowStemmer.setCurrent(word);
                this.snowStemmer.stem();
                return this.snowStemmer.getCurrent();
            }
            return null;
        }
    }
}

