/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jpos.tagger;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntTrainer;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import de.julielab.jcore.ae.jpos.pipes.FeatureGenerator;
import de.julielab.jcore.ae.jpos.tagger.Sentence;
import de.julielab.jcore.ae.jpos.tagger.Unit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSTagger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object model = null;
    private Properties featureConfig = null;
    private boolean trained = false;
    static Logger LOGGER = LoggerFactory.getLogger(POSTagger.class);
    private int number_iterations = 0;
    private Pipe generalPipe = null;
    private String defaultLabel;

    public POSTagger() {
        Properties defaults = new Properties();
        InputStream defaultFeatureConfigStream = this.getClass().getResourceAsStream("/defaultFeatureConf.conf");
        try {
            LOGGER.debug("loading default configuration");
            defaults.load(defaultFeatureConfigStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("", e);
        }
        this.featureConfig = new Properties(defaults);
    }

    public POSTagger(File featureConfigFile) {
        this.featureConfig = new Properties();
        if (!featureConfigFile.isFile()) {
            IllegalStateException e = new IllegalStateException("specified file for feature configuration not found!");
            LOGGER.error("", e);
            throw e;
        }
        try {
            this.featureConfig.load(new FileInputStream(featureConfigFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("", e);
        }
    }

    public boolean isTrained() {
        return this.trained;
    }

    public void train(ArrayList<Sentence> sentences) {
        System.out.println("   * training model... on " + sentences.size() + " sentences");
        this.defaultLabel = sentences.get(0).get(0).getLabel();
        FeatureGenerator featureGenerator = new FeatureGenerator();
        InstanceList data = featureGenerator.createFeatureData(sentences, this.featureConfig);
        this.generalPipe = data.getPipe();
        LOGGER.info("  * number of features for training: " + data.getDataAlphabet().size());
        long start = System.currentTimeMillis();
        InstanceList tokenData = FeatureGenerator.convertFeatsforClassifier(this.generalPipe, data);
        LOGGER.info("train() - now training on " + data.size() + " instances");
        MaxEntTrainer maxEntTrainer = new MaxEntTrainer();
        LOGGER.info("JNET ME training ...");
        MaxEnt me = null;
        me = this.number_iterations == 0 ? maxEntTrainer.train(tokenData) : maxEntTrainer.train(tokenData, this.number_iterations);
        this.model = me;
        long stop = System.currentTimeMillis();
        LOGGER.info("  * learning took (sec): " + (stop - start) / 1000L);
        this.trained = true;
    }

    public void predictForUIMA(Sentence sentence) {
        if (!this.trained || this.model == null) {
            IllegalStateException e = new IllegalStateException("No model available. Train or load trained model first.");
            LOGGER.error("", e);
            throw e;
        }
        Classifier classifier = (Classifier)this.model;
        this.predictSentence(sentence, classifier);
    }

    void predictSentence(Sentence sentence, Classifier classifier) {
        for (int i = 0; i < sentence.size(); ++i) {
            sentence.get(i).setLabel(this.defaultLabel);
        }
        Instance inst = this.generalPipe.instanceFrom(new Instance(sentence, "", "", ""));
        InstanceList tokenList = FeatureGenerator.convertFeatsforClassifier(classifier.getInstancePipe(), inst);
        LOGGER.info("current sentence has this number of token features: " + tokenList.size());
        ArrayList<Unit> tokens = sentence.getUnits();
        if (tokens.size() != tokenList.size()) {
            LOGGER.error("predict() - something went wrong with sequence feature conversion");
            System.exit(-1);
        }
        for (int j = 0; j < tokenList.size(); ++j) {
            Classification C = classifier.classify((Instance)tokenList.get(j));
            String label = C.getLabeling().getBestLabel().toString();
            Unit token = tokens.get(j);
            token.setLabel(label);
        }
    }

    public ArrayList<String> predictForCLI(ArrayList<Sentence> sentences) {
        if (!this.trained || this.model == null) {
            IllegalStateException e = new IllegalStateException("no model available. Train or load trained model first.");
            LOGGER.error("", e);
            throw e;
        }
        Classifier classifier = (Classifier)this.model;
        ArrayList<String> tagged = new ArrayList<String>();
        StringBuilder taggedSentence = new StringBuilder();
        for (Sentence sentence : sentences) {
            this.predictSentence(sentence, classifier);
            int limit = sentence.getUnits().size();
            for (int i = 0; i < limit; ++i) {
                Unit token = sentence.get(i);
                taggedSentence.append(String.format("%s|%s ", token.getRep(), token.getLabel()));
            }
            taggedSentence.replace(taggedSentence.length() - 1, taggedSentence.length(), "\n");
            tagged.add(taggedSentence.toString());
            taggedSentence.delete(0, taggedSentence.length());
        }
        return tagged;
    }

    public void writeModel(String filename) {
        if (!this.trained || this.model == null || this.featureConfig == null) {
            System.err.println("train or load trained model first.");
            System.exit(0);
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(filename));
            GZIPOutputStream gout = new GZIPOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(gout);
            oos.writeObject(this);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static POSTagger readModel(InputStream is) throws IOException, FileNotFoundException, ClassNotFoundException {
        GZIPInputStream gin = new GZIPInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(gin);
        POSTagger pos = (POSTagger)ois.readObject();
        ois.close();
        return pos;
    }

    public static POSTagger readModel(File modelFile) throws IOException, FileNotFoundException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(modelFile);
        return POSTagger.readModel(fis);
    }

    public Object getModel() {
        return this.model;
    }

    public void setFeatureConfig(Properties featureConfig) {
        this.featureConfig = featureConfig;
    }

    public Properties getFeatureConfig() {
        return this.featureConfig;
    }

    public Sentence textToUnits(String sentence) {
        String[] tokens = sentence.trim().split(" +");
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (String token : tokens) {
            units.add(new Unit(0, 0, token, ""));
        }
        return new Sentence(units);
    }

    public Sentence PPDtoUnits(String sentence) {
        String[] tokens = sentence.trim().split("[\t ]+");
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (String token : tokens) {
            new HashMap();
            String[] features = token.split("\\|+");
            String word = features[0];
            String label = features[features.length - 1];
            Unit unit = new Unit(0, 0, word, label);
            units.add(unit);
        }
        return new Sentence(units);
    }

    public int getNumber_Iterations() {
        return this.number_iterations;
    }

    public void set_Number_Iterations(int number_iter) {
        this.number_iterations = number_iter;
    }
}

