/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jpos.pipes;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.jcore.ae.jpos.pipes.NGramGenerator;
import java.util.ArrayList;

public class TokenNGramPipe
extends Pipe {
    private static final long serialVersionUID = 1L;
    private final int[] ngramSizes;

    public TokenNGramPipe(int[] ngramSizes) {
        this.ngramSizes = ngramSizes;
    }

    @Override
    public Instance pipe(Instance carrier) {
        int i;
        TokenSequence tokenSequence = (TokenSequence)carrier.getData();
        String[] tokenTexts = new String[tokenSequence.size()];
        for (i = 0; i < tokenSequence.size(); ++i) {
            Token t = (Token)tokenSequence.get(i);
            tokenTexts[i] = t.getText();
        }
        for (i = 0; i < tokenSequence.size(); ++i) {
            Token token = (Token)tokenSequence.get(i);
            ArrayList<String> ngrams = new NGramGenerator().generateTokenNGrams(tokenTexts, i, this.ngramSizes);
            for (String ngram : ngrams) {
                token.setFeatureValue("TOK_NGRAM=" + ngram, 1.0);
            }
        }
        return carrier;
    }
}

