/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.regression;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;

public class LinearRegression {
    public double[] parameters;
    Alphabet alphabet;
    int precisionIndex;
    int interceptIndex;

    public LinearRegression(Alphabet alphabet) {
        this.alphabet = alphabet;
        this.parameters = new double[alphabet.size() + 2];
        this.interceptIndex = this.parameters.length - 2;
        this.precisionIndex = this.parameters.length - 1;
    }

    public double[] getParameters() {
        return this.parameters;
    }

    public double predict(Instance instance) {
        double prediction = this.parameters[this.interceptIndex];
        FeatureVector predictors = (FeatureVector)instance.getData();
        int location = 0;
        while (location < predictors.numLocations()) {
            int index = predictors.indexAtLocation(location);
            prediction += this.parameters[index] * predictors.valueAtLocation(location);
            ++location;
        }
        return prediction;
    }
}

