/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class FeaturesOfFirstMention
extends Pipe
implements Serializable {
    String namePrefix;
    String firstMentionName;
    Pattern featureRegex;
    Pattern filterRegex;
    boolean includeFiltered;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public FeaturesOfFirstMention(String namePrefix, String firstMentionName, Pattern featureRegex) {
        this.namePrefix = namePrefix;
        this.firstMentionName = firstMentionName;
        this.featureRegex = featureRegex;
    }

    public FeaturesOfFirstMention(String namePrefix, Pattern featureRegex, Pattern featureFilterRegex, boolean includeFiltered) {
        this(namePrefix, null, featureRegex);
        this.filterRegex = featureFilterRegex;
        this.includeFiltered = includeFiltered;
    }

    public FeaturesOfFirstMention(String namePrefix, Pattern featureRegex) {
        this(namePrefix, null, featureRegex);
    }

    public FeaturesOfFirstMention(String namePrefix) {
        this(namePrefix, null);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int tsSize = ts.size();
        int i = tsSize - 1;
        while (i >= 0) {
            Token t = (Token)ts.get(i);
            String text = t.getText();
            if (this.featureRegex == null || this.featureRegex.matcher(text).matches()) {
                int j = 0;
                while (j < i) {
                    if (((Token)ts.get(j)).getText().equals(text)) {
                        PropertyList.Iterator iter = ((Token)ts.get(j)).getFeatures().iterator();
                        while (iter.hasNext()) {
                            iter.next();
                            String key = iter.getKey();
                            if (this.filterRegex != null && !(this.filterRegex.matcher(key).matches() ^ !this.includeFiltered)) continue;
                            t.setFeatureValue(String.valueOf(this.namePrefix) + key, iter.getNumericValue());
                        }
                        break;
                    }
                    if (this.firstMentionName != null) {
                        t.setFeatureValue(this.firstMentionName, 1.0);
                    }
                    ++j;
                }
            }
            --i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.namePrefix);
        out.writeObject(this.featureRegex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.namePrefix = (String)in.readObject();
        this.featureRegex = (Pattern)in.readObject();
    }
}

