/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.Labeling;
import cc.mallet.util.MalletLogger;
import java.lang.reflect.Array;
import java.util.logging.Logger;

public class Array2FeatureVector
extends Pipe {
    private static Logger logger = MalletLogger.getLogger(Array2FeatureVector.class.getName());

    public Array2FeatureVector(int capacity) {
        this.dataAlphabet = new Alphabet(capacity);
    }

    public Array2FeatureVector() {
        this(1000);
    }

    public Array2FeatureVector(Alphabet dataAlphabet, Alphabet targetAlphabet) {
        this.dataAlphabet = dataAlphabet;
        this.targetAlphabet = targetAlphabet;
    }

    @Override
    public Instance pipe(Instance carrier) throws IllegalStateException {
        int dataLength = Array.getLength(carrier.getData());
        if (dataLength > this.dataAlphabet.size()) {
            int k = this.dataAlphabet.size();
            while (k < dataLength) {
                this.dataAlphabet.lookupIndex(new Integer(k), true);
                ++k;
            }
        }
        FeatureVector fv = new FeatureVector(this.dataAlphabet, (double[])carrier.getData());
        if (this.targetAlphabet == null) {
            if (carrier.getTarget() instanceof Labeling) {
                this.targetAlphabet = ((Labeling)carrier.getTarget()).getLabelAlphabet();
            } else {
                throw new IllegalStateException("Instance target is not a Labeling; it is a " + carrier.getTarget().getClass().getName());
            }
        }
        carrier.setData(fv);
        return carrier;
    }

    public int size() {
        return this.dataAlphabet.size();
    }
}

