/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.fst.semi_supervised.constraints.OneLabelGEConstraints;
import gnu.trove.TIntObjectHashMap;

public class OneLabelL2GEConstraints
extends OneLabelGEConstraints {
    public OneLabelL2GEConstraints() {
    }

    private OneLabelL2GEConstraints(TIntObjectHashMap<OneLabelGEConstraints.OneLabelGEConstraint> constraints, StateLabelMap map) {
        super(constraints, map);
    }

    @Override
    public GEConstraint copy() {
        return new OneLabelL2GEConstraints(this.constraints, this.map);
    }

    @Override
    public void addConstraint(int fi, double[] target, double weight) {
        this.constraints.put(fi, new OneLabelGEL2Constraint(target, weight));
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            OneLabelGEConstraints.OneLabelGEConstraint constraint = (OneLabelGEConstraints.OneLabelGEConstraint)this.constraints.get(fi);
            if (constraint.count > 0.0) {
                double featureValue = 0.0;
                int labelIndex = 0;
                while (labelIndex < this.map.getNumLabels()) {
                    double ex = constraint.expectation[labelIndex] / constraint.count;
                    featureValue -= Math.pow(constraint.target[labelIndex] - ex, 2.0);
                    ++labelIndex;
                }
                assert (!Double.isNaN(featureValue) && !Double.isInfinite(featureValue));
                value += featureValue * constraint.weight;
            }
            ++n2;
        }
        return value;
    }

    protected class OneLabelGEL2Constraint
    extends OneLabelGEConstraints.OneLabelGEConstraint {
        public OneLabelGEL2Constraint(double[] target, double weight) {
            super(target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            return 2.0 * this.weight * (this.target[li] / this.count - this.expectation[li] / (this.count * this.count));
        }
    }
}

