/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    static ArgumentsMatchInfo compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(expectedArgTypes.size() == suppliedArgTypes.size(), "Expected argument types and supplied argument types should be arrays of same length");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int i = 0;
        while (i < expectedArgTypes.size() && match != null) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (!expectedArg.equals(suppliedArg)) {
                if (suppliedArg == null) {
                    if (expectedArg.isPrimitive()) {
                        match = null;
                    }
                } else if (suppliedArg.isAssignableTo(expectedArg)) {
                    if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                        match = ArgsMatchKind.CLOSE;
                    }
                } else if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList<Integer>();
                    }
                    argsRequiringConversion.add(i);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                } else {
                    match = null;
                }
            }
            ++i;
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            int i2 = 0;
            while (i2 < argsRequiringConversion.size()) {
                argsArray[i2] = (Integer)argsRequiringConversion.get(i2);
                ++i2;
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> paramTypes, List<TypeDescriptor> argTypes) {
        int result = 0;
        int i = 0;
        int max = paramTypes.size();
        while (i < max) {
            TypeDescriptor argType = argTypes.get(i);
            TypeDescriptor paramType = paramTypes.get(i);
            if (argType == null && paramType.isPrimitive()) {
                return Integer.MAX_VALUE;
            }
            if (!ClassUtils.isAssignable(paramType.getClass(), argType.getClass())) {
                return Integer.MAX_VALUE;
            }
            if (argType != null) {
                Class<Object> paramTypeClazz = paramType.getType();
                if (paramTypeClazz.isPrimitive()) {
                    paramTypeClazz = Object.class;
                }
                Class<?> superClass = argType.getClass().getSuperclass();
                while (superClass != null) {
                    if (paramType.equals(superClass)) {
                        result += 2;
                        superClass = null;
                        continue;
                    }
                    if (ClassUtils.isAssignable(paramTypeClazz, superClass)) {
                        result += 2;
                        superClass = superClass.getSuperclass();
                        continue;
                    }
                    superClass = null;
                }
                if (paramTypeClazz.isInterface()) {
                    ++result;
                }
            }
            ++i;
        }
        return result;
    }

    static ArgumentsMatchInfo compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(expectedArgTypes != null && expectedArgTypes.size() > 0, "Expected arguments must at least include one array (the vargargs parameter)");
        Assert.isTrue(expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), "Final expected argument should be array type (the varargs parameter)");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        int i = 0;
        while (i < argCountUpToVarargs && match != null) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (expectedArg.isPrimitive()) {
                    match = null;
                }
            } else if (!expectedArg.equals(suppliedArg)) {
                if (suppliedArg.isAssignableTo(expectedArg)) {
                    if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                        match = ArgsMatchKind.CLOSE;
                    }
                } else if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList<Integer>();
                    }
                    argsRequiringConversion.add(i);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                } else {
                    match = null;
                }
            }
            ++i;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals(suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            Class<?> varargsParameterType = expectedArgTypes.get(expectedArgTypes.size() - 1).getElementTypeDescriptor().getType();
            int i2 = expectedArgTypes.size() - 1;
            while (i2 < suppliedArgTypes.size()) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i2);
                if (suppliedArg == null) {
                    if (varargsParameterType.isPrimitive()) {
                        match = null;
                    }
                } else if (varargsParameterType != suppliedArg.getType()) {
                    if (ClassUtils.isAssignable(varargsParameterType, suppliedArg.getType())) {
                        if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                            match = ArgsMatchKind.CLOSE;
                        }
                    } else if (typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf(varargsParameterType))) {
                        if (argsRequiringConversion == null) {
                            argsRequiringConversion = new ArrayList();
                        }
                        argsRequiringConversion.add(i2);
                        match = ArgsMatchKind.REQUIRES_CONVERSION;
                    } else {
                        match = null;
                    }
                }
                ++i2;
            }
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            int i3 = 0;
            while (i3 < argsRequiringConversion.size()) {
                argsArray[i3] = (Integer)argsRequiringConversion.get(i3);
                ++i3;
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    static void convertArguments(TypeConverter converter, Object[] arguments, Object methodOrCtor, int[] argumentsRequiringConversion, Integer varargsPosition) throws EvaluationException {
        if (varargsPosition == null) {
            int i = 0;
            while (i < arguments.length) {
                TypeDescriptor targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor(methodOrCtor, i));
                Object argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                ++i;
            }
        } else {
            Object argument;
            TypeDescriptor targetType;
            int i = 0;
            while (i < varargsPosition) {
                targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor(methodOrCtor, i));
                argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                ++i;
            }
            MethodParameter methodParam = MethodParameter.forMethodOrConstructor(methodOrCtor, varargsPosition);
            if (varargsPosition == arguments.length - 1) {
                targetType = new TypeDescriptor(methodParam);
                argument = arguments[varargsPosition];
                arguments[varargsPosition.intValue()] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
            } else {
                targetType = TypeDescriptor.nested(methodParam, 1);
                int i2 = varargsPosition;
                while (i2 < arguments.length) {
                    Object argument2 = arguments[i2];
                    arguments[i2] = converter.convertValue(argument2, TypeDescriptor.forObject(argument2), targetType);
                    ++i2;
                }
            }
        }
    }

    public static void convertAllArguments(TypeConverter converter, Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = null;
        if (method.isVarArgs()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            varargsPosition = paramTypes.length - 1;
        }
        int argPosition = 0;
        while (argPosition < arguments.length) {
            TypeDescriptor targetType;
            if (varargsPosition != null && argPosition >= varargsPosition) {
                MethodParameter methodParam = new MethodParameter(method, (int)varargsPosition);
                targetType = TypeDescriptor.nested(methodParam, 1);
            } else {
                targetType = new TypeDescriptor(new MethodParameter(method, argPosition));
            }
            try {
                Object argument = arguments[argPosition];
                if (argument != null && !targetType.getObjectType().isInstance(argument)) {
                    if (converter == null) {
                        throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, argument.getClass().getName(), targetType);
                    }
                    arguments[argPosition] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                }
            }
            catch (EvaluationException ex) {
                if (ex instanceof SpelEvaluationException) {
                    throw (SpelEvaluationException)ex;
                }
                throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, arguments[argPosition].getClass().getName(), targetType);
            }
            ++argPosition;
        }
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class[] requiredParameterTypes, Object ... args) {
        int parameterCount = requiredParameterTypes.length;
        int argumentCount = args.length;
        if (parameterCount != args.length || requiredParameterTypes[parameterCount - 1] != (args[argumentCount - 1] == null ? null : args[argumentCount - 1].getClass())) {
            int arraySize = 0;
            if (argumentCount >= parameterCount) {
                arraySize = argumentCount - (parameterCount - 1);
            }
            Object[] newArgs = new Object[parameterCount];
            int i = 0;
            while (i < newArgs.length - 1) {
                newArgs[i] = args[i];
                ++i;
            }
            Class<?> componentType = requiredParameterTypes[parameterCount - 1].getComponentType();
            if (componentType.isPrimitive()) {
                if (componentType == Integer.TYPE) {
                    int[] repackagedArguments = (int[])Array.newInstance(componentType, arraySize);
                    int i2 = 0;
                    while (i2 < arraySize) {
                        repackagedArguments[i2] = (Integer)args[parameterCount + i2 - 1];
                        ++i2;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Float.TYPE) {
                    float[] repackagedArguments = (float[])Array.newInstance(componentType, arraySize);
                    int i3 = 0;
                    while (i3 < arraySize) {
                        repackagedArguments[i3] = ((Float)args[parameterCount + i3 - 1]).floatValue();
                        ++i3;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Double.TYPE) {
                    double[] repackagedArguments = (double[])Array.newInstance(componentType, arraySize);
                    int i4 = 0;
                    while (i4 < arraySize) {
                        repackagedArguments[i4] = (Double)args[parameterCount + i4 - 1];
                        ++i4;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Short.TYPE) {
                    short[] repackagedArguments = (short[])Array.newInstance(componentType, arraySize);
                    int i5 = 0;
                    while (i5 < arraySize) {
                        repackagedArguments[i5] = (Short)args[parameterCount + i5 - 1];
                        ++i5;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Character.TYPE) {
                    char[] repackagedArguments = (char[])Array.newInstance(componentType, arraySize);
                    int i6 = 0;
                    while (i6 < arraySize) {
                        repackagedArguments[i6] = ((Character)args[parameterCount + i6 - 1]).charValue();
                        ++i6;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Byte.TYPE) {
                    byte[] repackagedArguments = (byte[])Array.newInstance(componentType, arraySize);
                    int i7 = 0;
                    while (i7 < arraySize) {
                        repackagedArguments[i7] = (Byte)args[parameterCount + i7 - 1];
                        ++i7;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Boolean.TYPE) {
                    boolean[] repackagedArguments = (boolean[])Array.newInstance(componentType, arraySize);
                    int i8 = 0;
                    while (i8 < arraySize) {
                        repackagedArguments[i8] = (Boolean)args[parameterCount + i8 - 1];
                        ++i8;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                } else if (componentType == Long.TYPE) {
                    long[] repackagedArguments = (long[])Array.newInstance(componentType, arraySize);
                    int i9 = 0;
                    while (i9 < arraySize) {
                        repackagedArguments[i9] = (Long)args[parameterCount + i9 - 1];
                        ++i9;
                    }
                    newArgs[newArgs.length - 1] = repackagedArguments;
                }
            } else {
                Object[] repackagedArguments = (Object[])Array.newInstance(componentType, arraySize);
                int i10 = 0;
                while (i10 < arraySize) {
                    repackagedArguments[i10] = args[parameterCount + i10 - 1];
                    ++i10;
                }
                newArgs[newArgs.length - 1] = repackagedArguments;
            }
            return newArgs;
        }
        return args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }

    public static class ArgumentsMatchInfo {
        public final ArgsMatchKind kind;
        public int[] argsRequiringConversion;

        ArgumentsMatchInfo(ArgsMatchKind kind, int[] integers) {
            this.kind = kind;
            this.argsRequiringConversion = integers;
        }

        ArgumentsMatchInfo(ArgsMatchKind kind) {
            this.kind = kind;
        }

        public boolean isExactMatch() {
            return this.kind == ArgsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgsMatchKind.REQUIRES_CONVERSION;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ArgumentMatch: ").append((Object)this.kind);
            if (this.argsRequiringConversion != null) {
                sb.append("  (argsForConversion:");
                int i = 0;
                while (i < this.argsRequiringConversion.length) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.argsRequiringConversion[i]);
                    ++i;
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

