/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Settings;

public class Settings_impl
implements Settings {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private BufferedReader rdr;
    private Map<String, String> map;
    private Pattern evalPattern = Pattern.compile("\\$\\{.*?\\}");

    public Settings_impl() {
        this.map = new HashMap<String, String>();
    }

    @Override
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    public void load(InputStream in) throws IOException {
        String line;
        this.rdr = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String legalPunc = "./-~_";
        while ((line = this.getLine()) != null) {
            String value;
            String[] parts = line.split("\\s*[:=\\s]\\s*", 2);
            String name = parts[0];
            boolean validName = name.length() > 0;
            for (int i = 0; i < name.length() && validName; ++i) {
                validName = Character.isLetterOrDigit(name.charAt(i)) || "./-~_".indexOf(name.charAt(i)) >= 0;
            }
            if (!validName) {
                throw new IOException("Invalid name '" + name + "' --- characters must be alphanumeric or " + "./-~_");
            }
            if (parts.length == 1) {
                value = "";
            } else {
                value = parts[1];
                if (value.length() > 0 && value.charAt(0) == '[') {
                    value = this.getArray(value);
                }
            }
            if (!this.map.containsKey(name)) {
                this.map.put(name, value);
                continue;
            }
            if (value.equals(this.map.get(name))) continue;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "load", LOG_RESOURCE_BUNDLE, "UIMA_external_override_ignored__CONFIG", new Object[]{name, value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSystemDefaults() throws ResourceConfigurationException {
        String fnames = System.getProperty("UimaExternalOverrides");
        if (fnames != null) {
            for (String fname : fnames.split(",")) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "loadSystemDefaults", LOG_RESOURCE_BUNDLE, "UIMA_external_overrides_load__CONFIG", new Object[]{fname});
                try {
                    FileInputStream is = new FileInputStream(fname);
                    try {
                        this.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new ResourceConfigurationException("external_override_error", new Object[]{fname}, e);
                }
            }
        }
    }

    @Override
    public String lookUp(String name) throws ResourceConfigurationException {
        String value = this.map.get(name);
        if (value == null) {
            return null;
        }
        Matcher matcher = this.evalPattern.matcher(value);
        StringBuilder result = new StringBuilder(value.length() + 100);
        int lastEnd = 0;
        while (matcher.find()) {
            if (this.isEscaped(value, matcher.start())) {
                result.append(value.substring(lastEnd, matcher.start() + 1));
                lastEnd = matcher.start() + 1;
                continue;
            }
            result.append(value.substring(lastEnd, matcher.start()));
            lastEnd = matcher.end();
            String key = value.substring(matcher.start() + 2, lastEnd - 1);
            String val = this.lookUp(key);
            if (val == null) {
                throw new ResourceConfigurationException("external_override_invalid", new Object[]{name, key});
            }
            result.append(val);
        }
        if (lastEnd == 0) {
            return value;
        }
        result.append(value.substring(lastEnd));
        return result.toString();
    }

    private String getArray(String line) throws IOException {
        int iend = line.indexOf(93);
        while (iend >= 0 && this.isEscaped(line, iend)) {
            iend = line.indexOf(93, iend + 1);
        }
        if (iend >= 0) {
            if (iend + 1 < line.length()) {
                throw new IOException("Syntax error - invalid character(s) '" + line.substring(iend + 1, line.length()) + "' after end of array");
            }
            return line;
        }
        String nextline = this.getLine();
        if (nextline == null) {
            throw new IOException("Premature EOF - missing ']'");
        }
        iend = line.length() - 1;
        if (line.charAt(iend) == ',' && !this.isEscaped(line, iend) || line.equals("[") || nextline.charAt(0) == ']') {
            return line + this.getArray(nextline);
        }
        return line + "," + this.getArray(nextline);
    }

    private String getLine() throws IOException {
        String line = this.rdr.readLine();
        if (line == null) {
            return null;
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0 || trimmed.charAt(0) == '#' || trimmed.charAt(0) == '!') {
            return this.getLine();
        }
        if (!this.isEscaped(line, line.length())) {
            return trimmed;
        }
        return this.extendLine(trimmed);
    }

    private String extendLine(String line) throws IOException {
        int ilast = line.length() - 1;
        String next = this.rdr.readLine();
        if (next == null) {
            next = "";
        }
        line = line.substring(0, ilast) + next.trim();
        if (!this.isEscaped(next, next.length())) {
            return line.trim();
        }
        return this.extendLine(line);
    }

    private boolean isEscaped(String line, int ichar) {
        int i;
        for (i = ichar - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
        }
        return (ichar - i) % 2 == 0;
    }
}

