/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.flow.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class FixedFlowController
extends CasFlowController_ImplBase {
    public static final String PARAM_ACTION_AFTER_CAS_MULTIPLIER = "ActionAfterCasMultiplier";
    private static final int ACTION_CONTINUE = 0;
    private static final int ACTION_STOP = 1;
    private static final int ACTION_DROP = 2;
    private static final int ACTION_DROP_IF_NEW_CAS_PRODUCED = 3;
    private final List<String> mSequence = Collections.synchronizedList(new ArrayList());
    private int mActionAfterCasMultiplier;

    @Override
    public synchronized void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        if (this.getContext() == aContext) {
            return;
        }
        this.mSequence.clear();
        super.initialize(aContext);
        FlowConstraints flowConstraints = aContext.getAggregateMetadata().getFlowConstraints();
        if (flowConstraints instanceof FixedFlow) {
            String[] sequence;
            for (String key : sequence = ((FixedFlow)flowConstraints).getFixedFlow()) {
                if (!aContext.getAnalysisEngineMetaDataMap().containsKey(key)) {
                    throw new ResourceInitializationException("flow_controller_missing_delegate", new Object[]{this.getClass().getName(), key, aContext.getAggregateMetadata().getSourceUrlString()});
                }
                this.mSequence.add(key);
            }
        } else {
            throw new ResourceInitializationException("flow_controller_requires_flow_constraints", new Object[]{this.getClass().getName(), "fixedFlow", aContext.getAggregateMetadata().getSourceUrlString()});
        }
        String actionAfterCasMultiplier = (String)aContext.getConfigParameterValue(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        if ("continue".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 0;
        } else if ("stop".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 1;
        } else if ("drop".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 2;
        } else if ("dropIfNewCasProduced".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 3;
        } else if (actionAfterCasMultiplier == null) {
            this.mActionAfterCasMultiplier = 3;
        } else {
            throw new ResourceInitializationException("invalid_action_after_cas_multiplier", new Object[]{actionAfterCasMultiplier});
        }
    }

    @Override
    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        return new FixedFlowObject(0);
    }

    @Override
    public void addAnalysisEngines(Collection<String> aKeys) {
        this.mSequence.addAll(aKeys);
    }

    @Override
    public void removeAnalysisEngines(Collection<String> aKeys) throws AnalysisEngineProcessException {
        this.mSequence.removeAll(aKeys);
    }

    public static FlowControllerDescription getDescription() {
        FlowControllerDescription desc;
        URL descUrl = FixedFlowController.class.getResource("/org/apache/uima/flow/FixedFlowController.xml");
        try {
            desc = (FlowControllerDescription)UIMAFramework.getXMLParser().parse(new XMLInputSource(descUrl));
        }
        catch (InvalidXMLException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IOException e) {
            throw new UIMARuntimeException(e);
        }
        return desc;
    }

    class FixedFlowObject
    extends CasFlow_ImplBase {
        private int currentStep;
        private boolean wasPassedToCasMultiplier = false;
        private boolean casMultiplierProducedNewCas = false;
        private boolean internallyCreatedCas = false;

        public FixedFlowObject(int startStep) {
            this(startStep, false);
        }

        public FixedFlowObject(int startStep, boolean internallyCreatedCas) {
            this.currentStep = startStep;
            this.internallyCreatedCas = internallyCreatedCas;
        }

        @Override
        public Step next() throws AnalysisEngineProcessException {
            if (this.wasPassedToCasMultiplier) {
                switch (FixedFlowController.this.mActionAfterCasMultiplier) {
                    case 1: {
                        return new FinalStep();
                    }
                    case 2: {
                        return new FinalStep(this.internallyCreatedCas);
                    }
                    case 3: {
                        if (!this.casMultiplierProducedNewCas) break;
                        return new FinalStep(this.internallyCreatedCas);
                    }
                }
                this.wasPassedToCasMultiplier = false;
                this.casMultiplierProducedNewCas = false;
            }
            if (this.currentStep >= FixedFlowController.this.mSequence.size()) {
                return new FinalStep();
            }
            AnalysisEngineMetaData md = FixedFlowController.this.getContext().getAnalysisEngineMetaDataMap().get(FixedFlowController.this.mSequence.get(this.currentStep));
            if (md.getOperationalProperties().getOutputsNewCASes()) {
                this.wasPassedToCasMultiplier = true;
            }
            return new SimpleStep((String)FixedFlowController.this.mSequence.get(this.currentStep++));
        }

        @Override
        public Flow newCasProduced(CAS newCas, String producedBy) throws AnalysisEngineProcessException {
            this.casMultiplierProducedNewCas = true;
            int i = 0;
            while (!((String)FixedFlowController.this.mSequence.get(i)).equals(producedBy)) {
                ++i;
            }
            return new FixedFlowObject(i + 1, true);
        }
    }
}

