/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.pipeline;

import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCasIterable
implements Iterable<JCas> {
    private final CollectionReaderDescription reader;
    private final AnalysisEngineDescription[] engines;

    public JCasIterable(CollectionReaderDescription aReader, AnalysisEngineDescription ... aEngines) {
        this.reader = aReader;
        this.engines = aEngines;
    }

    public JCasIterator iterator() {
        try {
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            CollectionReader readerInst = UIMAFramework.produceCollectionReader(this.reader, resMgr, null);
            AnalysisEngineDescription aaeDesc = AnalysisEngineFactory.createEngineDescription(this.engines);
            AnalysisEngine aaeInst = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aaeDesc, resMgr, null);
            JCasIterator i = new JCasIterator(readerInst, aaeInst);
            i.setSelfComplete(true);
            i.setSelfDestroy(true);
            return i;
        }
        catch (UIMAException e) {
            throw new IllegalStateException(e);
        }
    }
}

