/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;

class FilteredIterator<T extends FeatureStructure>
extends FSIteratorImplBase<T> {
    private FSIterator<T> it;
    private FSMatchConstraint cons;

    private FilteredIterator() {
    }

    FilteredIterator(FSIterator<T> it, FSMatchConstraint cons) {
        this();
        this.it = it;
        this.cons = cons;
        this.moveToFirst();
    }

    @Override
    public boolean isValid() {
        return this.it.isValid();
    }

    @Override
    public void moveToFirst() {
        this.it.moveToFirst();
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToNext();
        }
    }

    @Override
    public void moveToLast() {
        this.it.moveToLast();
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToPrevious();
        }
    }

    @Override
    public void moveToNext() {
        this.it.moveToNext();
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToNext();
        }
    }

    @Override
    public void moveToPrevious() {
        this.it.moveToPrevious();
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToPrevious();
        }
    }

    @Override
    public T get() throws NoSuchElementException {
        return this.it.get();
    }

    @Override
    public FSIterator<T> copy() {
        return new FilteredIterator<T>(this.it.copy(), this.cons);
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        this.it.moveTo(fs);
        if (!this.cons.match((FeatureStructure)this.it.get())) {
            this.moveToNext();
        }
    }
}

