/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;

class FSIteratorAggregate<T extends FeatureStructure>
extends FSIteratorImplBase<T> {
    private final List<FSIterator<T>> iterators = new ArrayList<FSIterator<T>>();
    private int iteratorIndex = 0;

    public FSIteratorAggregate(Collection<FSIterator<T>> c) {
        this.iterators.addAll(c);
        this.moveToFirst();
    }

    @Override
    public FSIterator<T> copy() {
        ArrayList<FSIterator<T>> itCopies = new ArrayList<FSIterator<T>>(this.iterators.size());
        for (int i = 0; i < this.iterators.size(); ++i) {
            itCopies.add(this.iterators.get(i).copy());
        }
        FSIteratorAggregate<T> copy = new FSIteratorAggregate<T>(itCopies);
        copy.iteratorIndex = this.iteratorIndex;
        return copy;
    }

    @Override
    public T get() throws NoSuchElementException {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return this.iterators.get(this.iteratorIndex).get();
    }

    @Override
    public boolean isValid() {
        return this.iteratorIndex < this.iterators.size();
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        throw new UnsupportedOperationException("This operation is not supported on an aggregate iterator.");
    }

    @Override
    public void moveToFirst() {
        this.iteratorIndex = 0;
        while (this.iteratorIndex < this.iterators.size()) {
            FSIterator<T> it = this.iterators.get(this.iteratorIndex);
            it.moveToFirst();
            if (it.isValid()) {
                return;
            }
            ++this.iteratorIndex;
        }
    }

    @Override
    public void moveToLast() {
        this.iteratorIndex = this.iterators.size() - 1;
        while (this.iteratorIndex >= 0) {
            FSIterator<T> it = this.iterators.get(this.iteratorIndex);
            it.moveToLast();
            if (it.isValid()) {
                return;
            }
            --this.iteratorIndex;
        }
    }

    @Override
    public void moveToNext() {
        if (!this.isValid()) {
            return;
        }
        FSIterator<T> current = this.iterators.get(this.iteratorIndex);
        current.moveToNext();
        if (current.isValid()) {
            return;
        }
        ++this.iteratorIndex;
        while (this.iteratorIndex < this.iterators.size()) {
            current = this.iterators.get(this.iteratorIndex);
            current.moveToFirst();
            if (current.isValid()) {
                return;
            }
            ++this.iteratorIndex;
        }
    }

    @Override
    public void moveToPrevious() {
        if (!this.isValid()) {
            return;
        }
        FSIterator<T> current = this.iterators.get(this.iteratorIndex);
        current.moveToPrevious();
        if (current.isValid()) {
            return;
        }
        --this.iteratorIndex;
        while (this.iteratorIndex >= 0) {
            current = this.iterators.get(this.iteratorIndex);
            current.moveToLast();
            if (current.isValid()) {
                return;
            }
            --this.iteratorIndex;
        }
        this.iteratorIndex = this.iterators.size();
    }
}

