/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.ThreadInterruptedException;

public abstract class FSDirectory
extends Directory {
    private static MessageDigest DIGESTER;
    private boolean checked;
    protected File directory = null;
    private static final char[] HEX_DIGITS;
    public static final int DEFAULT_READ_CHUNK_SIZE;
    private int chunkSize = DEFAULT_READ_CHUNK_SIZE;

    private static File getCanonicalPath(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    final void createDir() throws IOException {
        if (!this.checked) {
            if (!this.directory.exists() && !this.directory.mkdirs()) {
                throw new IOException("Cannot create directory: " + this.directory);
            }
            this.checked = true;
        }
    }

    protected final void initOutput(String name) throws IOException {
        this.ensureOpen();
        this.createDir();
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
    }

    protected FSDirectory(File path, LockFactory lockFactory) throws IOException {
        path = FSDirectory.getCanonicalPath(path);
        if (lockFactory == null) {
            lockFactory = new NativeFSLockFactory();
        }
        this.directory = path;
        if (this.directory.exists() && !this.directory.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + this.directory + "' exists but is not a directory");
        }
        this.setLockFactory(lockFactory);
        if (lockFactory instanceof FSLockFactory) {
            FSLockFactory lf = (FSLockFactory)lockFactory;
            File dir2 = lf.getLockDir();
            if (dir2 == null) {
                lf.setLockDir(this.directory);
                lf.setLockPrefix(null);
            } else if (dir2.getCanonicalPath().equals(this.directory.getCanonicalPath())) {
                lf.setLockPrefix(null);
            }
        }
    }

    public static FSDirectory open(File path) throws IOException {
        return FSDirectory.open(path, null);
    }

    public static FSDirectory open(File path, LockFactory lockFactory) throws IOException {
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path, lockFactory);
        }
        return new NIOFSDirectory(path, lockFactory);
    }

    public static String[] listAll(File dir2) throws IOException {
        if (!dir2.exists()) {
            throw new NoSuchDirectoryException("directory '" + dir2 + "' does not exist");
        }
        if (!dir2.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + dir2 + "' exists but is not a directory");
        }
        String[] result = dir2.list(new FilenameFilter(){

            public boolean accept(File dir2, String file) {
                return !new File(dir2, file).isDirectory();
            }
        });
        if (result == null) {
            throw new IOException("directory '" + dir2 + "' exists and is a directory, but cannot be listed: list() returned null");
        }
        return result;
    }

    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    public boolean fileExists(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.exists();
    }

    public long fileModified(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public long fileLength(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.length();
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(String name) throws IOException {
        this.ensureOpen();
        File fullFile = new File(this.directory, name);
        boolean success = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success && retryCount < 5) {
            ++retryCount;
            RandomAccessFile file = null;
            try {
                Object var8_9;
                try {
                    file = new RandomAccessFile(fullFile, "rw");
                    file.getFD().sync();
                    success = true;
                    var8_9 = null;
                    if (file == null) continue;
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (file != null) {
                        file.close();
                    }
                    throw throwable;
                }
                file.close();
                {
                }
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }
        if (!success) {
            throw exc;
        }
    }

    public IndexInput openInput(String name) throws IOException {
        this.ensureOpen();
        return this.openInput(name, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLockID() {
        byte[] digest;
        String dirName;
        this.ensureOpen();
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuilder buf = new StringBuilder();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    public synchronized void close() {
        this.isOpen = false;
    }

    public File getFile() {
        this.ensureOpen();
        return this.directory;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.directory + " lockFactory=" + this.getLockFactory();
    }

    public final void setReadChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be positive");
        }
        if (!Constants.JRE_IS_64BIT) {
            this.chunkSize = chunkSize;
        }
    }

    public final int getReadChunkSize() {
        return this.chunkSize;
    }

    static {
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString(), e);
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DEFAULT_READ_CHUNK_SIZE = Constants.JRE_IS_64BIT ? Integer.MAX_VALUE : 0x6400000;
    }
}

