/*
 * Decompiled with CFR 0.152.
 */
package com.uea.stemmer;

import com.uea.stemmer.Word;
import java.io.Serializable;

public class UEALite
implements Serializable {
    private static final long serialVersionUID = 2960712918243165711L;
    private int maxWordLength = "deoxyribonucleicacid".length();
    private int maxAcronymLength = "CAVASSOO".length();

    public UEALite() {
    }

    public UEALite(int wordLength, int acronymLength) {
        this.maxWordLength = wordLength;
        this.maxAcronymLength = acronymLength;
    }

    public int getMaxWordLength() {
        return this.maxWordLength;
    }

    public int getMaxAcronymLength() {
        return this.maxAcronymLength;
    }

    public boolean setMaxWordLength(int length) {
        this.maxWordLength = length;
        return true;
    }

    public boolean setMaxAcronymLength(int length) {
        this.maxAcronymLength = length;
        return true;
    }

    public Word stem(String word) {
        String stemmed_word = word;
        double ruleno = 0.0;
        if (this.isProblemWord(word)) {
            return new Word(word, 90.0);
        }
        if (word.length() > this.maxWordLength) {
            return new Word(word, 95.0);
        }
        if (word.indexOf("'") != -1) {
            if (word.matches("^.*'[sS]$")) {
                stemmed_word = this.remove(word, "'s");
            }
            if (word.matches("^.*'$")) {
                stemmed_word = this.remove(word, "'");
            }
            stemmed_word = stemmed_word.replaceAll("n't", "not");
            stemmed_word = stemmed_word.replaceAll("'ve", "have");
            stemmed_word = stemmed_word.replaceAll("'re", "are");
            stemmed_word = stemmed_word.replaceAll("'m", "am");
            return new Word(stemmed_word, 94.0);
        }
        if (word.matches("^\\d+$")) {
            return new Word(word, 90.3);
        }
        if (word.matches("^\\w+-\\w+$")) {
            return new Word(word, 90.2);
        }
        if (word.matches("^.*-.*$")) {
            return new Word(word, 90.1);
        }
        if (word.matches("^.*_.*$")) {
            return new Word(word, 90.0);
        }
        if (word.matches("^\\p{Upper}+s$")) {
            return new Word(this.remove(word, "s"), 91.1);
        }
        if (word.matches("^\\p{Upper}+$")) {
            return new Word(word, 91.0);
        }
        if (word.matches("^\\p{Upper}+$")) {
            return new Word(word, 91.0);
        }
        if (word.matches("^.*\\p{Upper}.*\\p{Upper}.*$")) {
            return new Word(word, 92.0);
        }
        if (word.matches("^\\p{Upper}{1}.*$")) {
            return new Word(word, 92.0);
        }
        if (word.endsWith("aceous")) {
            stemmed_word = this.remove(word, "aceous");
            ruleno = 1.0;
        } else if (word.endsWith("ces")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 2.0;
        } else if (word.endsWith("cs")) {
            ruleno = 3.0;
        } else if (word.endsWith("sis")) {
            ruleno = 4.0;
        } else if (word.endsWith("tis")) {
            ruleno = 5.0;
        } else if (word.endsWith("ss")) {
            ruleno = 6.0;
        } else if (word.endsWith("eed")) {
            ruleno = 7.0;
        } else if (word.endsWith("eeds")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 7.0;
        } else if (word.endsWith("ued")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 8.0;
        } else if (word.endsWith("ues")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 9.0;
        } else if (word.endsWith("ees")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 10.0;
        } else if (word.endsWith("iases")) {
            stemmed_word = this.remove(word, "es");
            ruleno = 11.4;
        } else if (word.endsWith("uses")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 11.3;
        } else if (word.endsWith("sses")) {
            stemmed_word = this.remove(word, "es");
            ruleno = 11.2;
        } else if (word.endsWith("eses")) {
            stemmed_word = this.remove(word, "es");
            stemmed_word = String.valueOf(stemmed_word) + "is";
            ruleno = 11.1;
        } else if (word.endsWith("ses")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 11.0;
        } else if (word.endsWith("tled")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 12.5;
        } else if (word.endsWith("pled")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 12.4;
        } else if (word.endsWith("bled")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 12.3;
        } else if (word.endsWith("eled")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 12.2;
        } else if (word.endsWith("lled")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 12.1;
        } else if (word.endsWith("led")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 12.0;
        } else if (word.endsWith("ened")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 13.7;
        } else if (word.endsWith("ained")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 13.6;
        } else if (word.endsWith("erned")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 13.5;
        } else if (word.endsWith("rned")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 13.4;
        } else if (word.endsWith("nned")) {
            stemmed_word = this.remove(word, "ned");
            ruleno = 13.3;
        } else if (word.endsWith("oned")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 13.2;
        } else if (word.endsWith("gned")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 13.1;
        } else if (word.endsWith("ned")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 13.0;
        } else if (word.endsWith("ifted")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 14.0;
        } else if (word.endsWith("ected")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 15.0;
        } else if (word.endsWith("vided")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 16.0;
        } else if (word.endsWith("ved")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 17.0;
        } else if (word.endsWith("ced")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 18.0;
        } else if (word.endsWith("erred")) {
            stemmed_word = this.remove(word, "red");
            ruleno = 19.0;
        } else if (word.endsWith("urred")) {
            stemmed_word = this.remove(word, "red");
            ruleno = 20.5;
        } else if (word.endsWith("lored")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 20.4;
        } else if (word.endsWith("eared")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 20.3;
        } else if (word.endsWith("tored")) {
            stemmed_word = word.replaceFirst("ed", "e");
            ruleno = 20.2;
        } else if (word.endsWith("ered")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 20.1;
        } else if (word.endsWith("red")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 20.0;
        } else if (word.endsWith("reds")) {
            stemmed_word = this.remove(word, "ds");
            ruleno = 20.0;
        } else if (word.endsWith("tted")) {
            stemmed_word = this.remove(word, "ted");
            ruleno = 21.0;
        } else if (word.endsWith("noted")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 22.4;
        } else if (word.endsWith("leted")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 22.3;
        } else if (word.endsWith("uted")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 22.2;
        } else if (word.endsWith("ated")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 22.1;
        } else if (word.endsWith("ted")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 22.0;
        } else if (word.endsWith("anges")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 23.0;
        } else if (word.endsWith("aining")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 24.0;
        } else if (word.endsWith("acting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 25.0;
        } else if (word.endsWith("tting")) {
            stemmed_word = this.remove(word, "ting");
            ruleno = 26.0;
        } else if (word.endsWith("ttings")) {
            stemmed_word = this.remove(word, "tings");
            ruleno = 26.0;
        } else if (word.endsWith("viding")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 27.0;
        } else if (word.endsWith("ssed")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 28.0;
        } else if (word.endsWith("sed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 29.0;
        } else if (word.endsWith("titudes")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 30.0;
        } else if (word.endsWith("umed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 31.0;
        } else if (word.endsWith("ulted")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 32.0;
        } else if (word.endsWith("uming")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 33.0;
        } else if (word.endsWith("fulness")) {
            stemmed_word = this.remove(word, "ness");
            ruleno = 34.0;
        } else if (word.endsWith("ousness")) {
            stemmed_word = this.remove(word, "ness");
            ruleno = 35.0;
        } else if (word.endsWith("rabed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 36.1;
        } else if (word.endsWith("rebed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 36.1;
        } else if (word.endsWith("ribed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 36.1;
        } else if (word.endsWith("robed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 36.1;
        } else if (word.endsWith("rubed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 36.1;
        } else if (word.endsWith("bed")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 36.0;
        } else if (word.endsWith("beds")) {
            stemmed_word = this.remove(word, "eds");
            ruleno = 36.0;
        } else if (word.endsWith("ssing")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 37.0;
        } else if (word.endsWith("ssings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 37.0;
        } else if (word.endsWith("ulting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 38.0;
        } else if (word.endsWith("ving")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 39.0;
        } else if (word.endsWith("vings")) {
            stemmed_word = word.replaceFirst("ings", "e");
            ruleno = 39.0;
        } else if (word.endsWith("eading")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 40.7;
        } else if (word.endsWith("eadings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 40.7;
        } else if (word.endsWith("oading")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 40.6;
        } else if (word.endsWith("oadings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 40.6;
        } else if (word.endsWith("eding")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 40.5;
        } else if (word.endsWith("edings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 40.5;
        } else if (word.endsWith("dding")) {
            stemmed_word = this.remove(word, "ding");
            ruleno = 40.4;
        } else if (word.endsWith("ddings")) {
            stemmed_word = this.remove(word, "dings");
            ruleno = 40.4;
        } else if (word.endsWith("lding")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 40.3;
        } else if (word.endsWith("ldings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 40.3;
        } else if (word.endsWith("rding")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 40.2;
        } else if (word.endsWith("rdings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 40.2;
        } else if (word.endsWith("nding")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 40.1;
        } else if (word.endsWith("ndings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 40.1;
        } else if (word.endsWith("ding")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 40.0;
        } else if (word.endsWith("dings")) {
            stemmed_word = word.replaceFirst("ings", "e");
            ruleno = 40.0;
        } else if (word.endsWith("lling")) {
            stemmed_word = this.remove(word, "ling");
            ruleno = 41.0;
        } else if (word.endsWith("llings")) {
            stemmed_word = this.remove(word, "lings");
            ruleno = 41.0;
        } else if (word.endsWith("ealing")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 42.4;
        } else if (word.endsWith("ealings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 42.4;
        } else if (word.endsWith("oling")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 42.3;
        } else if (word.endsWith("olings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 42.3;
        } else if (word.endsWith("ailing")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 42.2;
        } else if (word.endsWith("ailings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 42.2;
        } else if (word.endsWith("eling")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 42.1;
        } else if (word.endsWith("elings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 42.1;
        } else if (word.endsWith("ling")) {
            stemmed_word = this.remove(word, "ing");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 42.0;
        } else if (word.endsWith("lings")) {
            stemmed_word = this.remove(word, "ings");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 42.0;
        } else if (word.endsWith("nged")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 43.2;
        } else if (word.endsWith("gged")) {
            stemmed_word = this.remove(word, "ged");
            ruleno = 43.1;
        } else if (word.endsWith("ged")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 43.0;
        } else if (word.endsWith("mming")) {
            stemmed_word = this.remove(word, "ming");
            ruleno = 44.3;
        } else if (word.endsWith("mmings")) {
            stemmed_word = this.remove(word, "mings");
            ruleno = 44.3;
        } else if (word.endsWith("rming")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 44.2;
        } else if (word.endsWith("lming")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 44.1;
        } else if (word.endsWith("ming")) {
            stemmed_word = this.remove(word, "ing");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 44.0;
        } else if (word.endsWith("mings")) {
            stemmed_word = this.remove(word, "ings");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 44.0;
        } else if (word.endsWith("nging")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 45.2;
        } else if (word.endsWith("ngings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 45.2;
        } else if (word.endsWith("gging")) {
            stemmed_word = this.remove(word, "ging");
            ruleno = 45.1;
        } else if (word.endsWith("ggings")) {
            stemmed_word = this.remove(word, "gings");
            ruleno = 45.1;
        } else if (word.endsWith("ging")) {
            stemmed_word = this.remove(word, "ing");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 45.0;
        } else if (word.endsWith("gings")) {
            stemmed_word = this.remove(word, "ings");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 45.0;
        } else if (word.endsWith("aning")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 46.6;
        } else if (word.endsWith("ening")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 46.5;
        } else if (word.endsWith("gning")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 46.4;
        } else if (word.endsWith("nning")) {
            stemmed_word = this.remove(word, "ning");
            ruleno = 46.3;
        } else if (word.endsWith("oning")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 46.2;
        } else if (word.endsWith("rning")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 46.1;
        } else if (word.endsWith("ning")) {
            stemmed_word = this.remove(word, "ing");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 46.0;
        } else if (word.endsWith("sting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 47.0;
        } else if (word.endsWith("stings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 47.0;
        } else if (word.endsWith("eting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 48.4;
        } else if (word.endsWith("etings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 48.4;
        } else if (word.endsWith("pting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 48.3;
        } else if (word.endsWith("nting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 48.2;
        } else if (word.endsWith("ntings")) {
            stemmed_word = this.remove(word, "ings");
            ruleno = 48.2;
        } else if (word.endsWith("cting")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 48.1;
        } else if (word.endsWith("ting")) {
            stemmed_word = this.remove(word, "ing");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 48.0;
        } else if (word.endsWith("tings")) {
            stemmed_word = this.remove(word, "ings");
            stemmed_word = stemmed_word.concat("e");
            ruleno = 48.0;
        } else if (word.endsWith("ssed")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 49.0;
        } else if (word.endsWith("les")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 50.0;
        } else if (word.endsWith("tes")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 51.0;
        } else if (word.endsWith("zed")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 52.0;
        } else if (word.endsWith("lled")) {
            stemmed_word = this.remove(word, "ed");
            ruleno = 53.0;
        } else if (word.endsWith("iring")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 54.4;
        } else if (word.endsWith("irings")) {
            stemmed_word = word.replaceFirst("ings", "e");
            ruleno = 54.4;
        } else if (word.endsWith("uring")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 54.3;
        } else if (word.endsWith("urings")) {
            stemmed_word = word.replaceFirst("ings", "e");
            ruleno = 54.3;
        } else if (word.endsWith("ncing")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 54.2;
        } else if (word.endsWith("ncings")) {
            stemmed_word = word.replaceFirst("ings", "e");
            ruleno = 54.2;
        } else if (word.endsWith("zing")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 54.1;
        } else if (word.endsWith("sing")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 54.0;
        } else if (word.endsWith("sings")) {
            stemmed_word = word.replaceFirst("ings", "e");
            ruleno = 54.0;
        } else if (word.endsWith("lling")) {
            stemmed_word = this.remove(word, "ing");
            ruleno = 55.0;
        } else if (word.endsWith("ied")) {
            stemmed_word = word.replaceFirst("ied", "y");
            ruleno = 56.0;
        } else if (word.endsWith("ating")) {
            stemmed_word = word.replaceFirst("ing", "e");
            ruleno = 57.0;
        } else if (word.endsWith("thing")) {
            ruleno = 58.1;
        } else if (word.endsWith("things")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 58.1;
        } else if (word.matches(".*\\w\\wings?$")) {
            stemmed_word = this.rule58(word);
            ruleno = 58.0;
        } else if (word.endsWith("ies")) {
            stemmed_word = word.replaceFirst("ies", "y");
            ruleno = 59.0;
        } else if (word.endsWith("lves")) {
            stemmed_word = word.replaceFirst("ves", "f");
            ruleno = 60.1;
        } else if (word.endsWith("ves")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 60.0;
        } else if (word.endsWith("aped")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 61.3;
        } else if (word.endsWith("uded")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 61.2;
        } else if (word.endsWith("oded")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 61.1;
        } else if (word.endsWith("ated")) {
            stemmed_word = this.remove(word, "d");
            ruleno = 61.0;
        } else if (word.matches(".*\\w\\weds?$")) {
            stemmed_word = this.rule62(word);
            ruleno = 62.0;
        } else if (word.endsWith("pes")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.8;
        } else if (word.endsWith("mes")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.7;
        } else if (word.endsWith("ones")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.6;
        } else if (word.endsWith("izes")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.5;
        } else if (word.endsWith("ures")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.4;
        } else if (word.endsWith("ines")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.3;
        } else if (word.endsWith("ides")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.2;
        } else if (word.endsWith("ges")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 63.1;
        } else if (word.endsWith("es")) {
            stemmed_word = this.remove(word, "es");
            ruleno = 63.0;
        } else if (word.endsWith("is")) {
            stemmed_word = word.replaceFirst("is", "e");
            ruleno = 64.0;
        } else if (word.endsWith("ous")) {
            ruleno = 65.0;
        } else if (word.endsWith("ums")) {
            ruleno = 66.0;
        } else if (word.endsWith("us")) {
            ruleno = 67.0;
        } else if (word.endsWith("s")) {
            stemmed_word = this.remove(word, "s");
            ruleno = 68.0;
        }
        return new Word(stemmed_word, ruleno);
    }

    private String rule58(String word) {
        String remove = "ing";
        return this.stemWithDuplicateCharacterCheck(word, remove);
    }

    private String rule62(String word) {
        String remove = "ed";
        return this.stemWithDuplicateCharacterCheck(word, remove);
    }

    private String stemWithDuplicateCharacterCheck(String word, String remove) {
        String stemmed_word;
        if (word.endsWith("s")) {
            remove = remove.concat("s");
        }
        if ((stemmed_word = this.remove(word, remove)).matches(".*(\\w)\\1$")) {
            stemmed_word = this.remove(stemmed_word, ".");
        }
        return stemmed_word;
    }

    private String remove(String word, String suffix) {
        return word.substring(0, word.length() - suffix.length());
    }

    private boolean isProblemWord(String word) {
        return word.equals("is") || word.equals("as") || word.equals("this") || word.equals("has") || word.equals("was") || word.equals("during");
    }
}

