/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtils {
    static Pattern schemeRegex = Pattern.compile("\\p{Alpha}[\\p{Alnum}\\+\\.-]*:");

    private static String defaultFileSchema(String string) {
        Matcher matcher = schemeRegex.matcher(string);
        if (!matcher.lookingAt()) {
            string = "file:" + string;
        }
        return string;
    }

    public static URI objectToUri(Object obj) {
        try {
            if (obj instanceof String) {
                return new URI(UriUtils.defaultFileSchema((String)obj));
            }
            if (obj instanceof File) {
                return new URI("file:" + ((File)obj).getAbsolutePath());
            }
            return new URI(obj.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("UriUtils.objectToUri: " + e.toString());
        }
    }

    public static String uriStringToFilename(String uri) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == File.pathSeparatorChar) {
                sb.append('+');
            } else if (c == '+') {
                sb.append("++");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String filenameToUriString(String filename) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < filename.length()) {
            char c = filename.charAt(i);
            if (c == '+') {
                if (i < filename.length() && filename.charAt(i + 1) == '+') {
                    sb.append('+');
                    ++i;
                } else {
                    sb.append(File.pathSeparator);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

