/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class Univariate {
    private static Logger logger = MalletLogger.getLogger(Univariate.class.getName());
    private double[] x;
    private double[] sortx;
    private double[] summary = new double[6];
    private boolean isSorted = false;
    public double[] five = new double[5];
    private int n;
    private double mean;
    private double variance;
    private double stdev;
    private double median;
    private double min;
    private double Q1;
    private double Q3;
    private double max;

    public Univariate(double[] data) {
        this.x = (double[])data.clone();
        this.n = this.x.length;
        this.createSummaryStats();
    }

    private void createSummaryStats() {
        this.mean = 0.0;
        int i = 0;
        while (i < this.n) {
            this.mean += this.x[i];
            ++i;
        }
        this.mean /= (double)this.n;
        this.variance = this.variance();
        this.stdev = this.stdev();
        double sumxx = 0.0;
        this.variance = 0.0;
        i = 0;
        while (i < this.n) {
            sumxx += this.x[i] * this.x[i];
            ++i;
        }
        if (this.n > 1) {
            this.variance = (sumxx - (double)this.n * this.mean * this.mean) / (double)(this.n - 1);
        }
        this.stdev = Math.sqrt(this.variance);
    }

    public double[] summary() {
        this.summary[0] = this.n;
        this.summary[1] = this.mean;
        this.summary[2] = this.variance;
        this.summary[3] = this.stdev;
        this.summary[4] = Math.sqrt(this.variance / (double)this.n);
        this.summary[5] = this.mean / this.summary[4];
        return this.summary;
    }

    public double mean() {
        return this.mean;
    }

    public double variance() {
        return this.variance;
    }

    public double stdev() {
        return this.stdev;
    }

    public double SE() {
        return Math.sqrt(this.variance / (double)this.n);
    }

    public double max() {
        if (!this.isSorted) {
            this.sortx = this.sort();
        }
        return this.sortx[this.n - 1];
    }

    public double min() {
        if (!this.isSorted) {
            this.sortx = this.sort();
        }
        return this.sortx[0];
    }

    public double median() {
        return this.quant(0.5);
    }

    public double quant(double q) {
        if (!this.isSorted) {
            this.sortx = this.sort();
        }
        if (q > 1.0 || q < 0.0) {
            return 0.0;
        }
        double index = (double)(this.n + 1) * q;
        if (index - (double)((int)index) == 0.0) {
            return this.sortx[(int)index - 1];
        }
        return q * this.sortx[(int)Math.floor(index) - 1] + (1.0 - q) * this.sortx[(int)Math.ceil(index) - 1];
    }

    public double[] sort() {
        this.sortx = (double[])this.x.clone();
        int incr = (int)((double)this.n * 0.5);
        while (incr >= 1) {
            int i = incr;
            while (i < this.n) {
                double temp = this.sortx[i];
                int j = i;
                while (j >= incr && temp < this.sortx[j - incr]) {
                    this.sortx[j] = this.sortx[j - incr];
                    j -= incr;
                }
                this.sortx[j] = temp;
                ++i;
            }
            incr /= 2;
        }
        this.isSorted = true;
        return this.sortx;
    }

    public double[] getData() {
        return this.x;
    }

    public int size() {
        return this.n;
    }

    public double elementAt(int index) {
        double element = 0.0;
        try {
            element = this.x[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.info("Index " + index + " does not exist in data.");
        }
        return element;
    }

    public double[] subset(int[] indices) {
        int k = indices.length;
        int i = 0;
        double[] elements = new double[k];
        try {
            i = 0;
            while (i < k) {
                elements[i] = this.x[k];
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.info("Index " + i + " does not exist in data.");
        }
        return elements;
    }

    public int compare(double t) {
        int index = this.n - 1;
        boolean found = false;
        int i = 0;
        while (i < this.n && !found) {
            if (this.sortx[i] > t) {
                index = i;
                found = true;
            }
            ++i;
        }
        return index;
    }

    public int[] between(double t1, double t2) {
        int[] indices = new int[]{this.compare(t1), this.compare(t2)};
        return indices;
    }

    public int indexOf(double element) {
        int index = -1;
        int i = 0;
        while (i < this.n) {
            if (Math.abs(this.x[i] - element) < 1.0E-6) {
                index = i;
            }
            ++i;
        }
        return index;
    }
}

