/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.util.ProgressMessageLogRecord;
import java.util.Arrays;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class ProgressMessageLogFormatter
extends SimpleFormatter {
    boolean lastMessageWasProgressMessage = false;
    int lastProgressMessageLength = 0;

    @Override
    public String format(LogRecord record) {
        int length = record.getMessage().length();
        if (record instanceof ProgressMessageLogRecord) {
            String suffix = "";
            if (this.lastMessageWasProgressMessage && this.lastProgressMessageLength > length) {
                int padding = this.lastProgressMessageLength - length;
                char[] c = new char[padding];
                Arrays.fill(c, ' ');
                suffix = new String(c);
            }
            this.lastMessageWasProgressMessage = true;
            this.lastProgressMessageLength = length;
            return String.valueOf(record.getMessage()) + suffix + "\r";
        }
        String prefix = this.lastMessageWasProgressMessage ? "\n" : "";
        this.lastMessageWasProgressMessage = false;
        return String.valueOf(prefix) + record.getMessage() + "\n";
    }
}

