/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.RankedFeatureVector;

public class PerLabelInfoGain {
    static final float log2 = (float)Math.log(2.0);
    static boolean binary = true;
    static boolean print = false;
    InfoGain[] ig;

    public PerLabelInfoGain(InstanceList ilist) {
        double[][] pcig = PerLabelInfoGain.calcPerLabelInfoGains(ilist);
        Alphabet v = ilist.getDataAlphabet();
        int numClasses = ilist.getTargetAlphabet().size();
        this.ig = new InfoGain[numClasses];
        int i = 0;
        while (i < numClasses) {
            this.ig[i] = new InfoGain(v, pcig[i]);
            ++i;
        }
    }

    public InfoGain getInfoGain(int classIndex) {
        return this.ig[classIndex];
    }

    public int getNumClasses() {
        return this.ig.length;
    }

    private static double entropy(double pc, double pnc) {
        assert (Math.abs(pc + pnc - 1.0) < 1.0E-4) : "pc=" + pc + " pnc=" + pnc;
        if (pc == 0.0 || pnc == 0.0) {
            return 0.0;
        }
        float ret = (float)(-pc * Math.log(pc) / (double)log2 - pnc * Math.log(pnc) / (double)log2);
        assert (ret >= 0.0f) : "pc=" + pc + " pnc=" + pnc;
        return ret;
    }

    public static double[][] calcPerLabelInfoGains(InstanceList ilist) {
        assert (binary);
        int numClasses = ilist.getTargetAlphabet().size();
        int numFeatures = ilist.getDataAlphabet().size();
        int numInstances = ilist.size();
        double[][] classFeatureCounts = new double[numClasses][numFeatures];
        int[] featureCounts = new int[numFeatures];
        int[] classCounts = new int[numClasses];
        int i = 0;
        while (i < ilist.size()) {
            int classIndex;
            Instance instance = (Instance)ilist.get(i);
            FeatureVector fv = (FeatureVector)instance.getData();
            int n = classIndex = instance.getLabeling().getBestIndex();
            classCounts[n] = classCounts[n] + 1;
            int fvi = 0;
            while (fvi < fv.numLocations()) {
                int featureIndex = fv.indexAtLocation(fvi);
                double[] dArray = classFeatureCounts[classIndex];
                int n2 = featureIndex;
                dArray[n2] = dArray[n2] + 1.0;
                int n3 = featureIndex;
                featureCounts[n3] = featureCounts[n3] + 1;
                assert (featureCounts[featureIndex] <= numInstances) : "fi=" + featureIndex + "ni=" + numInstances + " fc=" + featureCounts[featureIndex] + " i=" + i;
                ++fvi;
            }
            ++i;
        }
        Alphabet v = ilist.getDataAlphabet();
        if (print) {
            int ci = 0;
            while (ci < numClasses) {
                System.out.println(String.valueOf(ilist.getTargetAlphabet().lookupObject(ci).toString()) + "=" + ci);
                ++ci;
            }
        }
        double[] classEntropies = new double[numClasses];
        int ci = 0;
        while (ci < numClasses) {
            double pc = (double)classCounts[ci] / (double)numInstances;
            double pnc = ((double)numInstances - (double)classCounts[ci]) / (double)numInstances;
            classEntropies[ci] = PerLabelInfoGain.entropy(pc, pnc);
            ++ci;
        }
        int fi = 0;
        while (fi < numFeatures) {
            int ci2;
            double pf = (double)featureCounts[fi] / (double)numInstances;
            double pnf = ((double)numInstances - (double)featureCounts[fi]) / (double)numInstances;
            assert (pf >= 0.0);
            assert (pnf >= 0.0);
            if (print && fi < 10000) {
                System.out.print(v.lookupObject(fi).toString());
                ci2 = 0;
                while (ci2 < numClasses) {
                    System.out.print(" " + classFeatureCounts[ci2][fi]);
                    ++ci2;
                }
                System.out.println("");
            }
            ci2 = 0;
            while (ci2 < numClasses) {
                if (featureCounts[fi] == 0) {
                    classFeatureCounts[ci2][fi] = 0.0;
                } else {
                    double pc = classFeatureCounts[ci2][fi] / (double)featureCounts[fi];
                    double pnc = ((double)featureCounts[fi] - classFeatureCounts[ci2][fi]) / (double)featureCounts[fi];
                    double ef = PerLabelInfoGain.entropy(pc, pnc);
                    pc = ((double)classCounts[ci2] - classFeatureCounts[ci2][fi]) / (double)(numInstances - featureCounts[fi]);
                    pnc = ((double)(numInstances - featureCounts[fi]) - ((double)classCounts[ci2] - classFeatureCounts[ci2][fi])) / (double)(numInstances - featureCounts[fi]);
                    double enf = PerLabelInfoGain.entropy(pc, pnc);
                    classFeatureCounts[ci2][fi] = classEntropies[ci2] - (pf * ef + pnf * enf);
                    if (print && fi < 10000) {
                        System.out.println("pf=" + pf + " ef=" + ef + " pnf=" + pnf + " enf=" + enf + " e=" + classEntropies[ci2] + " cig=" + classFeatureCounts[ci2][fi]);
                    }
                }
                ++ci2;
            }
            ++fi;
        }
        if (print) {
            fi = 0;
            while (fi < 100) {
                String featureName = v.lookupObject(fi).toString();
                int ci3 = 0;
                while (ci3 < numClasses) {
                    String className = ilist.getTargetAlphabet().lookupObject(ci3).toString();
                    if (classFeatureCounts[ci3][fi] > 0.1) {
                        System.out.println(String.valueOf(featureName) + ',' + className + '=' + classFeatureCounts[ci3][fi]);
                    }
                    ++ci3;
                }
                ++fi;
            }
        }
        return classFeatureCounts;
    }

    public static class Factory
    implements RankedFeatureVector.PerLabelFactory {
        @Override
        public RankedFeatureVector[] newRankedFeatureVectors(InstanceList ilist) {
            PerLabelInfoGain x = new PerLabelInfoGain(ilist);
            return x.ig;
        }
    }
}

